/*
 * Decompiled with CFR 0.152.
 */
package templateInput.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import templateInput.definition.FlowReceiverDefinition;
import templateInput.definition.InitializedTypeDefinition;
import templateInput.definition.TypeDefinition;
import templateInput.definition.VariableDefinition;

public class MethodDefinition
extends InitializedTypeDefinition {
    private List<VariableDefinition> parameters = new ArrayList<VariableDefinition>();
    private List<FlowReceiverDefinition> changedFields = new ArrayList<FlowReceiverDefinition>();
    private List<MethodDefinition> inputMethods = new ArrayList<MethodDefinition>();
    private List<MethodDefinition> outputMethods = new ArrayList<MethodDefinition>();
    private String callSignature;
    private String returnSignature;
    private String expectedReturn;
    private String instance;

    private MethodDefinition(Builder builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.changedFields = builder.changedFields == null ? this.changedFields : builder.changedFields;
        this.inputMethods = builder.inputMethods == null ? this.inputMethods : builder.inputMethods;
        this.outputMethods = builder.outputMethods == null ? this.outputMethods : builder.outputMethods;
        this.callSignature = builder.callSignature == null ? this.callSignature : builder.callSignature;
        this.returnSignature = builder.returnSignature == null ? this.returnSignature : builder.returnSignature;
    }

    public List<VariableDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<VariableDefinition> parameters) {
        this.parameters = parameters;
    }

    public List<FlowReceiverDefinition> getChangedFields() {
        return this.changedFields;
    }

    public void setChangedFields(List<FlowReceiverDefinition> changedFields) {
        this.changedFields = changedFields;
    }

    public List<MethodDefinition> getInputMethods() {
        return this.inputMethods;
    }

    public void setInputMethods(List<MethodDefinition> inputMethods) {
        this.inputMethods = inputMethods;
    }

    public void addInputMethod(MethodDefinition inputMethod) {
        this.inputMethods.add(inputMethod);
    }

    public List<MethodDefinition> getOutputMethods() {
        return this.outputMethods;
    }

    public void setOutputMethods(List<MethodDefinition> outputMethods) {
        this.outputMethods = outputMethods;
    }

    public void addOutputMethod(MethodDefinition method) {
        this.outputMethods.add(method);
    }

    public String getCallSignature() {
        return this.callSignature;
    }

    public void setCallSignature(String callSignature) {
        this.callSignature = callSignature;
    }

    public String getReturnSignature() {
        return this.returnSignature;
    }

    public void setReturnSignature(String returnSignature) {
        this.returnSignature = returnSignature;
    }

    public String getExpectedReturn() {
        return this.expectedReturn;
    }

    public void setExpectedReturn(String expectedReturn) {
        this.expectedReturn = expectedReturn;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("parameters", (Object)("[" + this.parameters.stream().map(TypeDefinition::getNameAsString).collect(Collectors.joining(",")) + "]")).build();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            MethodDefinition other = (MethodDefinition)obj;
            equals = new EqualsBuilder().appendSuper(super.equals(other)).append(this.parameters, other.parameters).isEquals();
        }
        return equals;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends InitializedTypeDefinition.Builder<Builder> {
        private List<VariableDefinition> parameters = new ArrayList<VariableDefinition>();
        private List<FlowReceiverDefinition> changedFields = new ArrayList<FlowReceiverDefinition>();
        private List<MethodDefinition> inputMethods = new ArrayList<MethodDefinition>();
        private List<MethodDefinition> outputMethods = new ArrayList<MethodDefinition>();
        private String callSignature;
        private String returnSignature;

        private Builder() {
        }

        public MethodDefinition build() {
            return new MethodDefinition(this);
        }

        public Builder parameters(List<VariableDefinition> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder parameters(VariableDefinition ... parameters) {
            this.parameters = Arrays.asList(parameters);
            return this;
        }

        public Builder changedFields(List<FlowReceiverDefinition> changedFields) {
            this.changedFields.clear();
            this.changedFields.addAll(changedFields);
            return this;
        }

        public Builder inputMethods(List<MethodDefinition> inputMethods) {
            this.inputMethods.clear();
            this.inputMethods.addAll(inputMethods);
            return this;
        }

        public Builder outputMethods(List<MethodDefinition> outputMethods) {
            this.outputMethods.clear();
            this.outputMethods.addAll(outputMethods);
            return this;
        }

        public Builder callSignature(String callSignature) {
            this.callSignature = callSignature;
            return this;
        }

        public Builder returnSignature(String returnSignature) {
            this.returnSignature = returnSignature;
            return this;
        }
    }
}

