/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen;

import com.java_podio.code_gen.CodeGenerator;
import com.java_podio.code_gen.FetchAppInfo;
import com.podio.app.Application;
import com.podio.oauth.OAuthUserCredentials;
import com.podio.oauth.OAuthUsernameCredentials;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CodeGenMain {
    public static void main(String[] args) throws JClassAlreadyExistsException, IOException {
        if (args.length < 3) {
            System.out.println("Usage: java -jar code-gen.jar PODIOUSERNAME PODIOPASSWORD APPID_1 .. APPID_N");
            System.out.println("       java -jar code-gen.jar PODIOUSERNAME PODIOPASSWORD -space SPACEID");
            return;
        }
        String username = args[0];
        String password = args[1];
        if ("-space".equalsIgnoreCase(args[2])) {
            CodeGenMain.generateSpace(username, password, Integer.parseInt(args[3]), new File("."), "podio.generated", "UTF-8");
        } else {
            ArrayList<Integer> appIds = new ArrayList<Integer>();
            for (int i = 2; i < args.length; ++i) {
                appIds.add(Integer.parseInt(args[i]));
            }
            CodeGenMain.generateApps(username, password, appIds, new File("."), "podio.generated", "UTF-8");
        }
    }

    public static void generateSpace(String user, String password, Integer spaceId, File outputFolder, String basePackage, String encoding) throws JClassAlreadyExistsException, IOException {
        OAuthUsernameCredentials usercredentials = new OAuthUsernameCredentials(user, password);
        FetchAppInfo appInfo = new FetchAppInfo((OAuthUserCredentials)usercredentials);
        ArrayList<Application> appInfos = new ArrayList<Application>();
        appInfos.addAll(appInfo.fetchAppsForSpace(spaceId));
        CodeGenMain.generateSources(outputFolder, basePackage, appInfos, encoding);
    }

    public static void generateApps(String user, String password, List<Integer> appIds, File outputFolder, String basePackage, String encoding) throws JClassAlreadyExistsException, IOException {
        OAuthUsernameCredentials usercredentials = new OAuthUsernameCredentials(user, password);
        FetchAppInfo appInfo = new FetchAppInfo((OAuthUserCredentials)usercredentials);
        ArrayList<Application> appInfos = new ArrayList<Application>();
        for (Integer appId : appIds) {
            appInfos.add(appInfo.fetchApp(appId));
        }
        CodeGenMain.generateSources(outputFolder, basePackage, appInfos, encoding);
    }

    static void generateSources(File outputFolder, String basePackage, List<Application> appInfos, String encoding) throws JClassAlreadyExistsException, IOException {
        CodeGenerator codeGen = new CodeGenerator(basePackage);
        JCodeModel jCodeModel = codeGen.generateCode(appInfos);
        FileCodeWriter writer = new FileCodeWriter(outputFolder, encoding);
        jCodeModel.build((CodeWriter)writer);
    }
}

