/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen;

import com.java_podio.code_gen.EnumGenerator;
import com.java_podio.code_gen.static_classes.PodioCurrency;
import com.java_podio.code_gen.static_classes.PodioDate;
import com.podio.app.ApplicationField;
import com.podio.app.ApplicationFieldType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public enum PodioType {
    UNDEFINED(Object.class),
    TEXT(String.class),
    NUMBER(Double.class),
    MONEY(PodioCurrency.class),
    CATEGORY_SINGLE(EnumGenerator.class),
    CATEGORY_MULTI(EnumGenerator.class),
    APP(List.class),
    DATE(PodioDate.class),
    DURATION(Integer.class),
    PROGRESS(Integer.class),
    CONTACT(List.class),
    EMBED(List.class);

    private static final Logger LOGGER;
    private final Class<? extends Object> javaType;
    private static Map<PodioType, ApplicationFieldType> map;

    private PodioType(Class<? extends Object> javaType) {
        this.javaType = javaType;
    }

    public Class<? extends Object> getJavaType() {
        return this.javaType;
    }

    public ApplicationFieldType getApplicationFieldType() {
        return map.get((Object)this);
    }

    public static PodioType forApplicationField(ApplicationField f) {
        if (ApplicationFieldType.CATEGORY.equals((Object)f.getType())) {
            if (Boolean.TRUE.equals(f.getConfiguration().getSettings().getMultiple())) {
                return CATEGORY_MULTI;
            }
            return CATEGORY_SINGLE;
        }
        for (PodioType podioType : map.keySet()) {
            if (!map.get((Object)podioType).equals((Object)f.getType())) continue;
            return podioType;
        }
        LOGGER.warning("cannot determine type of field: " + f.getType() + "(" + f.getConfiguration().getLabel() + ", " + f.getStatus() + ")");
        return UNDEFINED;
    }

    static {
        LOGGER = Logger.getLogger(PodioType.class.getName());
        map = new HashMap<PodioType, ApplicationFieldType>();
        map.put(TEXT, ApplicationFieldType.TEXT);
        map.put(NUMBER, ApplicationFieldType.NUMBER);
        map.put(MONEY, ApplicationFieldType.MONEY);
        map.put(APP, ApplicationFieldType.APP);
        map.put(DATE, ApplicationFieldType.DATE);
        map.put(DURATION, ApplicationFieldType.DURATION);
        map.put(PROGRESS, ApplicationFieldType.PROGRESS);
        map.put(CONTACT, ApplicationFieldType.CONTACT);
        map.put(EMBED, ApplicationFieldType.EMBED);
    }
}

