/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_classes;

import com.java_podio.code_gen.static_classes.PodioCategory;
import com.podio.contact.Profile;
import com.podio.embed.Embed;
import com.podio.file.File;
import com.podio.item.FieldValuesUpdate;
import com.podio.item.FieldValuesView;
import com.podio.item.Item;
import com.podio.item.ItemCreate;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AppWrapper
implements Serializable {
    static final long serialVersionUID = 1L;
    protected Item originalItem;
    protected Integer podioId;
    protected Integer podioRevision;
    protected String podioTitle;
    protected List<String> podioTags;
    protected List<File> files;

    public void setValue(Item item) throws ParseException {
        this.setOriginalItem(item);
        this.podioId = item.getId();
        if (item.getCurrentRevision() != null) {
            this.podioRevision = item.getCurrentRevision().getRevision();
        }
        this.podioTitle = item.getTitle();
        this.podioTags = item.getTags();
        this.files = item.getFiles();
    }

    public Item getOriginalItem() {
        return this.originalItem;
    }

    public void setOriginalItem(Item originalItem) {
        this.originalItem = originalItem;
    }

    public Integer getPodioId() {
        return this.podioId;
    }

    public void setPodioId(Integer podioId) {
        this.podioId = podioId;
    }

    public Integer getPodioRevision() {
        return this.podioRevision;
    }

    public void setPodioRevision(Integer podioRevision) {
        this.podioRevision = podioRevision;
    }

    public String getPodioTitle() {
        return this.podioTitle;
    }

    public void setPodioTitle(String podioTitle) {
        this.podioTitle = podioTitle;
    }

    public List<String> getPodioTags() {
        return this.podioTags;
    }

    public void setPodioTags(List<String> podioTags) {
        this.podioTags = podioTags;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void addFileById(Integer fileId) {
        File f = new File();
        f.setId(fileId.intValue());
        List<File> files = this.getFiles();
        if (files == null) {
            files = new ArrayList<File>();
        }
        files.add(f);
        this.setFiles(files);
    }

    public List<Integer> getFileIds() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.getFiles() != null) {
            for (File f : this.getFiles()) {
                result.add(f.getId());
            }
        }
        return result;
    }

    public ItemCreate getItemCreate() {
        ItemCreate result = new ItemCreate();
        if (this.getAppExternalId() != null) {
            result.setExternalId(this.getAppExternalId());
        }
        if (this.getPodioRevision() != null) {
            result.setRevision(this.getPodioRevision().intValue());
        }
        if (this.getPodioTags() != null) {
            result.setTags(this.getPodioTags());
        }
        ArrayList fieldValuesList = new ArrayList();
        result.setFields(fieldValuesList);
        if (this.getFiles() != null) {
            result.setFileIds(this.getFileIds());
        }
        return result;
    }

    public abstract String getAppExternalId();

    public abstract Integer getAppId();

    public String toString() {
        String result = "AppWrapper [";
        result = result + "originalItem=" + this.originalItem;
        result = result + ", podioId=" + this.podioId;
        result = result + ", podioRevision=" + this.podioRevision;
        result = result + ", podioTitle=" + this.podioTitle;
        result = result + ", podioTags=" + this.podioTags;
        result = result + ", files=" + this.files;
        return result + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
        result = 31 * result + (this.podioId == null ? 0 : this.podioId.hashCode());
        result = 31 * result + (this.podioRevision == null ? 0 : this.podioRevision.hashCode());
        result = 31 * result + (this.podioTags == null ? 0 : this.podioTags.hashCode());
        result = 31 * result + (this.podioTitle == null ? 0 : this.podioTitle.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppWrapper other = (AppWrapper)obj;
        if (this.files == null ? other.files != null : !this.files.equals(other.files)) {
            return false;
        }
        if (this.podioId == null ? other.podioId != null : !this.podioId.equals(other.podioId)) {
            return false;
        }
        if (this.podioRevision == null ? other.podioRevision != null : !this.podioRevision.equals(other.podioRevision)) {
            return false;
        }
        if (this.podioTags == null ? other.podioTags != null : !this.podioTags.equals(other.podioTags)) {
            return false;
        }
        return !(this.podioTitle == null ? other.podioTitle != null : !this.podioTitle.equals(other.podioTitle));
    }

    protected static List<Integer> parseAppField(FieldValuesView fieldValue) throws ParseException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List entries = fieldValue.getValues();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Integer value = (Integer)((Map)((Map)iterator.next()).get("value")).get("item_id");
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    protected static FieldValuesUpdate getFieldValuesUpdateFromApp(List<Integer> ids, String externalId) {
        if (ids == null) {
            return null;
        }
        ArrayList<Map<String, Integer>> values = new ArrayList<Map<String, Integer>>();
        for (Integer id : ids) {
            values.add(Collections.singletonMap("value", id));
        }
        return new FieldValuesUpdate(externalId, values);
    }

    protected static <T extends PodioCategory> FieldValuesUpdate getFielddValuesUpdateFromMultiCategory(List<T> selections, String externalId) {
        if (selections == null) {
            return null;
        }
        ArrayList<Map<String, Integer>> values = new ArrayList<Map<String, Integer>>();
        for (PodioCategory selection : selections) {
            values.add(Collections.singletonMap("value", new Integer(selection.getPodioId())));
        }
        return new FieldValuesUpdate(externalId, values);
    }

    protected static <T extends Enum<T>> List<T> parseMultiCategoryField(FieldValuesView f, Class<T> enumtype) {
        ArrayList<Enum> result = new ArrayList<Enum>();
        try {
            for (Map value : f.getValues()) {
                Integer id = (Integer)((Map)value.get("value")).get("id");
                Object enumvalue = enumtype.getMethod("byId", Integer.TYPE).invoke(null, (int)id);
                result.add((Enum)enumvalue);
            }
        }
        catch (TypeNotPresentException e) {
            e.printStackTrace();
            return result;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return result;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return result;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return result;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return result;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    protected static FieldValuesUpdate getFieldValuesUpdateFromContacts(List<Profile> profiles, String externalId) {
        if (profiles == null) {
            return null;
        }
        ArrayList<Map<String, Integer>> values = new ArrayList<Map<String, Integer>>();
        for (Profile profile : profiles) {
            values.add(Collections.singletonMap("value", new Integer(profile.getProfileId())));
        }
        return new FieldValuesUpdate(externalId, values);
    }

    protected static FieldValuesUpdate getFieldValuesUpdateFromEmbeds(List<Embed> embeds, String externalId) {
        if (embeds == null) {
            return null;
        }
        ArrayList<Map<String, Integer>> values = new ArrayList<Map<String, Integer>>();
        for (Embed embed : embeds) {
            values.add(Collections.singletonMap("embed", embed.getId()));
        }
        return new FieldValuesUpdate(externalId, values);
    }

    protected static <T> List<T> parseFieldJson(FieldValuesView f, Class<T> type, String elementKey) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy"));
        ArrayList<Object> result = new ArrayList<Object>();
        List entries = f.getValues();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Object element = objectMapper.convertValue(((Map)iterator.next()).get(elementKey), type);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }
}

