/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_interface;

import com.java_podio.code_gen.static_classes.AppWrapper;
import com.java_podio.code_gen.static_interface.GenericPodioInterface;
import com.java_podio.code_gen.static_interface.PodioApiWrapperException;
import com.java_podio.code_gen.static_interface.PodioConflictException;
import com.podio.item.ItemBadge;
import com.podio.item.filter.ItemFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JProgressBar;

public abstract class GenericPodioInterfaceProxy {
    private static final Logger LOGGER = Logger.getLogger(GenericPodioInterfaceProxy.class.getName());
    private static final Map<Class<? extends AppWrapper>, Map<Integer, AppWrapper>> cache = Collections.synchronizedMap(new HashMap());

    protected static <T extends AppWrapper> T getCachedItem(Class<T> type, Integer podioId) {
        if (!cache.containsKey(type)) {
            cache.put(type, Collections.synchronizedMap(new HashMap()));
        }
        if (podioId == null) {
            return null;
        }
        return (T)cache.get(type).get(podioId);
    }

    protected static <T extends AppWrapper> T getCachedItem(T item) {
        return (T)GenericPodioInterfaceProxy.getCachedItem(item.getClass(), item.getPodioId());
    }

    protected static <T extends AppWrapper> boolean isCached(T item) {
        return item.equals(GenericPodioInterfaceProxy.getCachedItem(item));
    }

    protected static <T extends AppWrapper> void cacheItem(Class<T> type, AppWrapper item) {
        if (!cache.containsKey(type)) {
            cache.put(type, Collections.synchronizedMap(new HashMap()));
        }
        if (item.getPodioId() == null) {
            throw new IllegalArgumentException("Cannot cache item without podio id!");
        }
        try {
            cache.get(type).put(item.getPodioId(), GenericPodioInterfaceProxy.copyItem(item));
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "could not (de-)serialize item!", e);
        }
    }

    protected static <T extends AppWrapper> void cacheItems(Collection<T> items) {
        for (AppWrapper item : items) {
            GenericPodioInterfaceProxy.cacheItem(item.getClass(), item);
        }
    }

    protected static <T extends AppWrapper> T copyItem(T item) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baOs = new ByteArrayOutputStream();
        ObjectOutputStream oOs = new ObjectOutputStream(baOs);
        oOs.writeObject(item);
        ByteArrayInputStream bais = new ByteArrayInputStream(baOs.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (T)((AppWrapper)ois.readObject());
    }

    public static void printCache() {
        LOGGER.fine("Cache: " + cache);
    }

    public static <T extends GenericPodioInterface> T proxify(T original, Class<T> interfaceType) {
        LOGGER.info("Using GenericPodioInterfaceProxy on " + original.getClass().getCanonicalName());
        return (T)((GenericPodioInterface)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, new GenericPodioInterfaceInvokationHandler<T>(original, interfaceType)));
    }

    public static GenericPodioInterface proxify(GenericPodioInterface original) {
        return GenericPodioInterfaceProxy.proxify(original, GenericPodioInterface.class);
    }

    public static void clearCache() {
        cache.clear();
    }

    private static class PodioProxy
    implements GenericPodioInterface {
        private GenericPodioInterface original;

        public PodioProxy(GenericPodioInterface original) {
            this.original = original;
        }

        @Override
        public int uploadFile(File file, int appId, String filename) {
            return this.original.uploadFile(file, appId, filename);
        }

        @Override
        public int addItem(AppWrapper item) {
            int podioId = this.original.addItem(item);
            GenericPodioInterfaceProxy.cacheItem(item.getClass(), item);
            return podioId;
        }

        @Override
        public <T extends AppWrapper> T getItemById(Class<T> type, Integer podioId) {
            T result = this.original.getItemById(type, podioId);
            GenericPodioInterfaceProxy.cacheItem(type, result);
            return result;
        }

        @Override
        public <T extends AppWrapper> List<T> getItemsById(Class<T> type, List<Integer> podioIds) {
            List<T> result = this.original.getItemsById(type, podioIds);
            GenericPodioInterfaceProxy.cacheItems(result);
            return result;
        }

        @Override
        public <T extends AppWrapper> List<T> getItemsById(Class<T> type, List<Integer> podioIds, JProgressBar progressBar) {
            List<T> result = this.original.getItemsById(type, podioIds);
            GenericPodioInterfaceProxy.cacheItems(result);
            return result;
        }

        @Override
        public <T extends AppWrapper> List<T> updateItems(List<T> items) throws ParseException, PodioConflictException {
            ArrayList<AppWrapper> unchangedItems = new ArrayList<AppWrapper>();
            List<AppWrapper> changedItems = new ArrayList<AppWrapper>();
            for (AppWrapper item : items) {
                if (!GenericPodioInterfaceProxy.isCached(item)) {
                    changedItems.add(item);
                    continue;
                }
                unchangedItems.add(item);
            }
            LOGGER.info("Cached items: " + unchangedItems);
            GenericPodioInterfaceProxy.printCache();
            changedItems = this.original.updateItems(changedItems);
            GenericPodioInterfaceProxy.cacheItems(changedItems);
            changedItems.addAll(unchangedItems);
            LOGGER.info("UnCached items: " + changedItems);
            LOGGER.info("saved update calls for PodioIds: " + unchangedItems.size());
            return changedItems;
        }

        @Override
        public <T extends AppWrapper> T updateItem(T item) throws PodioConflictException {
            if (GenericPodioInterfaceProxy.isCached(item)) {
                LOGGER.info("saved update call for PodioId: " + item.getPodioId());
                return item;
            }
            T updatedItem = this.original.updateItem(item);
            GenericPodioInterfaceProxy.cacheItem(updatedItem.getClass(), updatedItem);
            return updatedItem;
        }

        @Override
        public <T extends AppWrapper> List<T> updateItems(Collection<T> items, JProgressBar progressBar) throws ParseException, PodioConflictException {
            ArrayList<AppWrapper> unchangedItems = new ArrayList<AppWrapper>();
            List<AppWrapper> changedItems = new ArrayList<AppWrapper>();
            for (AppWrapper item : items) {
                if (!GenericPodioInterfaceProxy.isCached(item)) {
                    changedItems.add(item);
                    continue;
                }
                unchangedItems.add(item);
            }
            LOGGER.info("Cached items: " + unchangedItems);
            LOGGER.info("UnCached items: " + changedItems);
            GenericPodioInterfaceProxy.printCache();
            changedItems = this.original.updateItems(changedItems, progressBar);
            GenericPodioInterfaceProxy.cacheItems(changedItems);
            changedItems.addAll(unchangedItems);
            LOGGER.info("saved update calls for PodioIds: " + unchangedItems.size());
            return changedItems;
        }

        @Override
        public <T extends AppWrapper> List<T> filterAllItems(Class<T> app, ItemFilter filter) throws InterruptedException, ExecutionException {
            LOGGER.info("Cacheing..");
            List<T> result = this.original.filterAllItems(app, filter);
            GenericPodioInterfaceProxy.cacheItems(result);
            return result;
        }

        @Override
        public Stream<ItemBadge> filterAllItemsStream(int appId, ItemFilter filter) {
            LOGGER.info("Not Cacheing!");
            return this.original.filterAllItemsStream(appId, filter);
        }

        @Override
        public <T extends AppWrapper> Stream<T> filterAllItemsAppWrapperStream(Class<T> app, ItemFilter filter, boolean fetchCompleteItems) {
            return this.cacheStream(this.original.filterAllItemsAppWrapperStream(app, filter, fetchCompleteItems));
        }

        private <T extends AppWrapper> Stream<T> cacheStream(Stream<T> tStream) {
            LOGGER.info("caching stream..");
            return tStream.map(appWrapper -> {
                GenericPodioInterfaceProxy.cacheItem(appWrapper.getClass(), appWrapper);
                return appWrapper;
            });
        }

        @Override
        public <T extends AppWrapper> List<T> filterAllItems(Class<T> app, ItemFilter filter, boolean fetchCompleteItem) {
            LOGGER.info("Cacheing..");
            List<T> result = this.original.filterAllItems(app, filter, fetchCompleteItem);
            GenericPodioInterfaceProxy.cacheItems(result);
            return result;
        }

        @Override
        public <T extends AppWrapper> List<T> getAllItems(Class<T> app) throws InterruptedException, ExecutionException {
            LOGGER.info("Cacheing..");
            List<T> result = this.original.getAllItems(app);
            GenericPodioInterfaceProxy.cacheItems(result);
            return result;
        }

        @Override
        public <T extends AppWrapper> List<T> getAssociatedItems(Class<T> type, String fieldId, Integer podioId) throws PodioApiWrapperException {
            List<T> result = this.original.getAssociatedItems(type, fieldId, podioId);
            GenericPodioInterfaceProxy.cacheItems(result);
            return result;
        }
    }

    private static class GenericPodioInterfaceInvokationHandler<T extends GenericPodioInterface>
    implements InvocationHandler {
        private final T original;
        private final GenericPodioInterface podioProxy;

        public GenericPodioInterfaceInvokationHandler(T original, Class<T> interfaceType) {
            this.original = original;
            this.podioProxy = new PodioProxy((GenericPodioInterface)original);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method proxyMethod = this.existsMethod(this.podioProxy, method);
            if (proxyMethod != null) {
                return proxyMethod.invoke((Object)this.podioProxy, args);
            }
            return method.invoke(this.original, args);
        }

        private Method existsMethod(Object object, Method method) {
            try {
                return object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }
}

