/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_interface;

import com.java_podio.code_gen.static_classes.AppWrapper;
import com.java_podio.code_gen.static_interface.GenericPodioInterface;
import com.java_podio.code_gen.static_interface.ItemFilterSpliterator;
import com.java_podio.code_gen.static_interface.PodioApiWrapperException;
import com.java_podio.code_gen.static_interface.PodioConflictException;
import com.java_podio.code_gen.static_interface.PodioMapper;
import com.podio.APIApplicationException;
import com.podio.BaseAPI;
import com.podio.file.FileAPI;
import com.podio.filter.FilterBy;
import com.podio.filter.FilterByValue;
import com.podio.item.Item;
import com.podio.item.ItemAPI;
import com.podio.item.ItemBadge;
import com.podio.item.ItemCreate;
import com.podio.item.ItemUpdate;
import com.podio.item.ItemsResponse;
import com.podio.item.filter.ItemFilter;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.JProgressBar;

public abstract class GenericPodioImpl
implements GenericPodioInterface {
    private static final Logger LOGGER = Logger.getLogger(GenericPodioImpl.class.getName());
    public static final int DEFAULT_OFFSET = 500;
    public static SimpleDateFormat defaultDateFormatNoTime = new SimpleDateFormat("dd.MM.yyyy");

    protected abstract <T extends BaseAPI> T getAPI(Integer var1, Class<T> var2);

    @Override
    public int uploadFile(File file, int appId, String filename) {
        return this.getAPI(appId, FileAPI.class).uploadFile(filename, file);
    }

    @Override
    public int addItem(AppWrapper item) {
        ItemCreate itemCreate = item.getItemCreate();
        int podioId = this.getAPI(item.getAppId(), ItemAPI.class).addItem(item.getAppId().intValue(), itemCreate, false);
        item.setPodioId(podioId);
        return podioId;
    }

    @Override
    public <T extends AppWrapper> T getItemById(Class<T> type, Integer podioId) {
        AppWrapper result = null;
        Item item = null;
        try {
            result = (AppWrapper)GenericPodioImpl.newAppWrapper(type, null);
            item = this.getAPI(result.getAppId(), ItemAPI.class).getItem(podioId.intValue());
            result.setValue(item);
        }
        catch (PodioApiWrapperException e1) {
            LOGGER.log(Level.SEVERE, "Could not create AppWrapper of type=" + type, e1);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Could not parse item: " + item + " to type: " + type, e);
        }
        return (T)result;
    }

    @Override
    public <T extends AppWrapper> List<T> getItemsById(Class<T> type, List<Integer> podioIds) {
        return this.getItemsById(type, podioIds, null);
    }

    @Override
    public <T extends AppWrapper> List<T> getItemsById(Class<T> type, List<Integer> podioIds, JProgressBar progressBar) {
        if (progressBar != null) {
            progressBar.setValue(progressBar.getMinimum());
            progressBar.setString("downloading items");
            progressBar.setMaximum(podioIds.size());
        }
        ArrayList<T> result = new ArrayList<T>(podioIds.size());
        for (int i = 0; i < podioIds.size(); ++i) {
            Integer id = podioIds.get(i);
            result.add(this.getItemById(type, id));
            if (progressBar == null) continue;
            progressBar.setValue(i + 1);
        }
        if (progressBar != null) {
            progressBar.setString(null);
        }
        return result;
    }

    @Override
    public <T extends AppWrapper> T updateItem(T item) throws PodioConflictException {
        try {
            this.getAPI(item.getAppId(), ItemAPI.class).updateItem(item.getPodioId().intValue(), (ItemUpdate)item.getItemCreate(), false, false);
            return (T)this.getItemById(item.getClass(), item.getPodioId());
        }
        catch (APIApplicationException e) {
            if (e.getError() != null && e.getError().equals("conflict")) {
                throw new PodioConflictException(e);
            }
            throw e;
        }
    }

    @Override
    public <T extends AppWrapper> List<T> updateItems(List<T> items) throws ParseException, PodioConflictException {
        return this.updateItems(items, null);
    }

    @Override
    public <T extends AppWrapper> List<T> updateItems(Collection<T> items, JProgressBar progressBar) throws ParseException, PodioConflictException {
        LOGGER.info("Updateing " + items.size() + " items.");
        if (progressBar != null) {
            progressBar.setValue(progressBar.getMinimum());
            progressBar.setString("sending updates");
            progressBar.setMaximum(items.size());
        }
        ArrayList<AppWrapper> updatedItems = new ArrayList<AppWrapper>();
        try {
            int i = 1;
            for (AppWrapper t : items) {
                LOGGER.info("Update item: " + t.toString());
                AppWrapper updatedItem = this.updateItem(t);
                updatedItems.add(updatedItem);
                if (progressBar == null) continue;
                progressBar.setValue(i++);
            }
        }
        catch (APIApplicationException e) {
            if (e.getError() != null && e.getError().equals("conflict")) {
                throw new PodioConflictException(e);
            }
            throw e;
        }
        if (progressBar != null) {
            progressBar.setString(null);
        }
        return updatedItems;
    }

    @Override
    public <T extends AppWrapper> List<T> filterAllItems(Class<T> app, ItemFilter filter) throws InterruptedException, ExecutionException {
        return this.filterAllItems(app, filter, false);
    }

    @Override
    public Stream<ItemBadge> filterAllItemsStream(int appId, ItemFilter filter) {
        return StreamSupport.stream(new ItemFilterSpliterator(appId, filter, this.getAPI(appId, ItemAPI.class)), true);
    }

    @Override
    public <T extends AppWrapper> Stream<T> filterAllItemsAppWrapperStream(Class<T> app, ItemFilter filter, boolean fetchCompleteItems) {
        try {
            Integer appId = ((AppWrapper)GenericPodioImpl.newAppWrapper(app, null)).getAppId();
            Stream<AppWrapper> appWrapperStream = this.filterAllItemsStream(appId, filter).map(PodioMapper::toItem).map(item -> GenericPodioImpl.newAppWrapperNoException(app, item));
            if (fetchCompleteItems) {
                LOGGER.info("fetching item details..");
                ItemAPI api = this.getAPI(appId, ItemAPI.class);
                appWrapperStream = ((Stream)appWrapperStream.parallel()).map(appWrapper -> api.getItem(appWrapper.getPodioId().intValue())).map(item -> GenericPodioImpl.newAppWrapperNoException(app, item));
            }
            return appWrapperStream;
        }
        catch (PodioApiWrapperException e) {
            throw new IllegalStateException("Could not determine app id for: " + app, e);
        }
    }

    @Override
    public <T extends AppWrapper> List<T> filterAllItems(Class<T> app, ItemFilter filter, boolean fetchCompleteItems) {
        return this.filterAllItemsAppWrapperStream(app, filter, fetchCompleteItems).collect(Collectors.toList());
    }

    @Override
    public <T extends AppWrapper> List<T> getAllItems(Class<T> app) throws InterruptedException, ExecutionException {
        return this.filterAllItems(app, new ItemFilter());
    }

    @Override
    public <T extends AppWrapper> List<T> getAssociatedItems(Class<T> type, final String fieldId, Integer podioId) throws PodioApiWrapperException {
        int appId = ((AppWrapper)GenericPodioImpl.newAppWrapper(type, null)).getAppId();
        ItemsResponse response = this.getAPI(appId, ItemAPI.class).getItems(appId, Integer.valueOf(500), Integer.valueOf(0), null, null, new FilterByValue[]{new FilterByValue((FilterBy)new FilterBy<Integer>(){

            public String getKey() {
                return fieldId;
            }

            public String format(Integer value) {
                return value.toString();
            }
        }, (Object)podioId)});
        ArrayList<T> result = new ArrayList<T>(response.getTotal());
        for (ItemBadge itemBadge : response.getItems()) {
            result.add(GenericPodioImpl.newAppWrapper(type, PodioMapper.toItem(itemBadge)));
        }
        return result;
    }

    public static <T extends AppWrapper> T newAppWrapper(Class<T> type, Item item) throws PodioApiWrapperException {
        AppWrapper result;
        try {
            result = item != null ? (AppWrapper)type.getConstructor(Item.class).newInstance(item) : (AppWrapper)type.newInstance();
        }
        catch (Exception e) {
            throw new PodioApiWrapperException("Could not instantiate type=" + type + " with item" + item, e);
        }
        return (T)result;
    }

    public static <T extends AppWrapper> T newAppWrapperNoException(Class<T> type, Item item) {
        try {
            return GenericPodioImpl.newAppWrapper(type, item);
        }
        catch (PodioApiWrapperException e) {
            throw new IllegalStateException(e);
        }
    }
}

