/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_interface;

import com.podio.item.ItemAPI;
import com.podio.item.ItemBadge;
import com.podio.item.filter.ItemFilter;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.logging.Logger;

class ItemFilterSpliterator
extends Spliterators.AbstractSpliterator<ItemBadge> {
    private static final Logger LOGGER = Logger.getLogger(ItemFilterSpliterator.class.getName());
    private final ConcurrentLinkedQueue<ItemBadge> queue = new ConcurrentLinkedQueue();
    private final AtomicReference<RuntimeException> exception = new AtomicReference<Object>(null);
    private final AtomicInteger jobsStarted = new AtomicInteger(0);
    private final AtomicInteger jobsFinished = new AtomicInteger(0);
    private final AtomicInteger splits = new AtomicInteger(0);
    protected long est = Long.MAX_VALUE;

    public ItemFilterSpliterator(int appId, ItemFilter filter, ItemAPI api) {
        super(Long.MAX_VALUE, 1281);
        Integer originalLimit = filter.getLimit();
        if (filter.getLimit() == null || filter.getLimit() > 500) {
            filter.setLimit(Integer.valueOf(500));
        }
        filter.setOffset(Integer.valueOf(0));
        this.startJob();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> api.filterItems(appId, filter)).thenAccept(r -> {
            int actualLimit = originalLimit != null ? Math.min(originalLimit, r.getFiltered()) : r.getFiltered();
            this.est = actualLimit;
            this.queue.addAll(r.getItems());
            for (int offset = 500; offset < actualLimit; offset += 500) {
                ItemFilter offsetFilter = new ItemFilter(filter);
                offsetFilter.setOffset(Integer.valueOf(offset));
                this.startJob();
                ExecutorService service = Executors.newCachedThreadPool();
                ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> api.filterItems(appId, offsetFilter), service).thenAccept(result -> this.queue.addAll(result.getItems()))).exceptionally(e -> {
                    this.exception.set(e instanceof RuntimeException ? (RuntimeException)e : new IllegalStateException((Throwable)e));
                    return null;
                })).thenAccept(r2 -> this.jobFinished());
            }
        })).exceptionally(e -> {
            this.exception.set(e instanceof RuntimeException ? (RuntimeException)e : new IllegalStateException((Throwable)e));
            return null;
        })).thenAccept(r3 -> this.jobFinished());
    }

    private void startJob() {
        int no = this.jobsStarted.incrementAndGet();
        LOGGER.info("Started fetch job  #" + no);
    }

    private void jobFinished() {
        int no = this.jobsFinished.incrementAndGet();
        LOGGER.info("Finished fetch job #" + no);
    }

    @Override
    public long estimateSize() {
        return this.est / (long)(this.splits.get() + 1);
    }

    @Override
    public Spliterator<ItemBadge> trySplit() {
        int currentSplits = this.splits.get();
        if (currentSplits >= this.maxSplits()) {
            return null;
        }
        boolean increased = this.splits.compareAndSet(currentSplits, currentSplits + 1);
        if (!increased) {
            return this.trySplit();
        }
        LOGGER.info("created split #" + (currentSplits + 1));
        return new Spliterator<ItemBadge>(){

            @Override
            public boolean tryAdvance(Consumer<? super ItemBadge> action) {
                return ItemFilterSpliterator.this.tryAdvance(action);
            }

            @Override
            public Spliterator<ItemBadge> trySplit() {
                return ItemFilterSpliterator.this.trySplit();
            }

            @Override
            public long estimateSize() {
                return ItemFilterSpliterator.this.estimateSize();
            }

            @Override
            public int characteristics() {
                return ItemFilterSpliterator.this.characteristics();
            }
        };
    }

    protected int maxSplits() {
        return 10;
    }

    @Override
    public boolean tryAdvance(Consumer<? super ItemBadge> action) {
        ItemBadge element;
        while ((element = this.queue.poll()) == null && this.exception.get() == null && this.jobsStarted.get() != this.jobsFinished.get()) {
            LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
        }
        if (this.exception.get() != null) {
            LOGGER.info("rethrowing exception: " + this.exception.get());
            throw this.exception.get();
        }
        if (element == null) {
            return false;
        }
        action.accept((ItemBadge)element);
        return true;
    }
}

