/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.application.web;

import com.github.developframework.kite.spring.mvc.response.KiteResponse;
import develop.framework.application.web.kite.res.ErrorKiteResponse;
import develop.framework.application.web.kite.res.ErrorReasonKiteResponse;
import develop.framework.application.web.kite.res.ValidatedKiteResponse;
import develop.framework.commons.enums.Level;
import develop.framework.commons.exceptions.BusinessException;
import develop.framework.commons.exceptions.FrameworkException;
import develop.framework.commons.exceptions.UnexpectedException;
import develop.framework.commons.exceptions.ValidatedArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class FrameworkControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(FrameworkControllerAdvice.class);

    @ExceptionHandler(value={BusinessException.class})
    public KiteResponse businessException(BusinessException businessException) {
        return new ErrorReasonKiteResponse(businessException);
    }

    @ExceptionHandler(value={ValidatedArgumentException.class})
    public KiteResponse validatedArgumentException(ValidatedArgumentException validatedArgumentException) {
        return new ValidatedKiteResponse(validatedArgumentException);
    }

    @ExceptionHandler(value={UnexpectedException.class})
    public KiteResponse unexpectedException(UnexpectedException unexpectedException) {
        log.warn("[ {} ] {}", (Object)unexpectedException.getLevel().name(), (Object)unexpectedException.getMessage());
        return new ErrorKiteResponse(unexpectedException.getLevel(), unexpectedException.getMessage());
    }

    @ExceptionHandler(value={FrameworkException.class})
    public KiteResponse frameworkException(FrameworkException frameworkException) {
        log.error("[ {} ] {}", (Object)frameworkException.getLevel().name(), (Object)frameworkException.getMessage());
        return new ErrorKiteResponse(frameworkException.getLevel(), frameworkException.getMessage());
    }

    @ExceptionHandler(value={Throwable.class})
    public KiteResponse anyThrowable(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return new ErrorKiteResponse(Level.FATAL, throwable.getMessage());
    }
}

