/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.security.MessageDigest;
import java.util.Properties;

public class FileUtil {
    static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final String HASH_TYPE = "SHA1";
    public static final int FILE_BYTE_SIZE = 1024;
    public static final int FILE_CACHE_SIZE = 2048;
    public static final int FILE_CONTENT_SIZE = 1000;
    public static final String sep = File.separator;
    public static final String defaultEncoding = "utf-8";

    public static String getExtName(File f) {
        String fileName = f.getName();
        String ext = "";
        if (fileName.lastIndexOf(".") >= 0) {
            ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return ext;
    }

    public static int getFileSize(String fullPath) {
        return FileUtil.getFileSize(new File(fullPath));
    }

    public static int getFileSize(File f) {
        int attSize = 0;
        try {
            attSize = (int)f.length() / 1024;
            if (f.length() > 0L && f.length() < 1L) {
                attSize = 1;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return attSize;
    }

    public static void copyFile(String fromFullPath, String toFullPath) throws Exception {
        FileUtil.copyFile(new File(fromFullPath), new File(toFullPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File fromFile, File toFile) throws Exception {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            File toPath = new File(toFile.getParent());
            if (!toPath.exists()) {
                toPath.mkdirs();
            }
            bis = new BufferedInputStream(new FileInputStream(fromFile));
            bos = new BufferedOutputStream(new FileOutputStream(toFile));
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (FileNotFoundException fe) {
            System.out.println(fe.getMessage());
            throw new FileNotFoundException(fe.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            bis.close();
            bos.close();
        }
    }

    public boolean exists(String path, String fileName) {
        boolean b = false;
        File dir = new File(path);
        if (dir.isDirectory()) {
            String[] str = dir.list();
            for (int i = 0; i < str.length; ++i) {
                if (!fileName.equals(str[i])) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    public static void writeFile(String fullPath, String content) {
        FileUtil.writeFile(fullPath, content, false);
    }

    public static void writeFile(String path, String fileName, String content, boolean b) {
        if (!path.substring(path.length() - 1).equals(sep)) {
            path = path + sep;
        }
        FileUtil.writeFile(path + fileName, content, b);
    }

    public static void writeFile(String fullPath, String content, boolean b) {
        File f = new File(fullPath);
        FileUtil.writeFile(f, content, b);
    }

    public static void writeFile(File f, String content, boolean b) {
        PrintWriter pw = null;
        try {
            if (!f.exists()) {
                try {
                    new File(f.getParent()).mkdirs();
                    f.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            pw = new PrintWriter(new FileOutputStream(f, b), true);
            pw.println(content);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] key, String file) {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            out.write(key);
            System.out.println("KEY:" + file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String readTextFile(String fullPath) {
        return FileUtil.readTextFile(fullPath, defaultEncoding);
    }

    public static String readTextFile(String fullPath, String encoding) {
        StringBuffer fileContent;
        block16: {
            fileContent = new StringBuffer("");
            BufferedReader br = null;
            try {
                if (!new File(fullPath).exists()) {
                    try {
                        String string = null;
                        return string;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block16;
                    }
                }
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullPath), encoding));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            String line = br.readLine();
            while (line != null) {
                fileContent.append(line + "\n");
                line = br.readLine();
            }
        }
        return fileContent.toString();
    }

    public static String loadBaseFile(String fullPath) {
        StringBuffer fileContent;
        block17: {
            fileContent = new StringBuffer(1000);
            BufferedInputStream bi = null;
            try {
                if (!new File(fullPath).exists()) {
                    try {
                        String string = null;
                        return string;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block17;
                    }
                }
                bi = new BufferedInputStream(new FileInputStream(fullPath));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    if (bi != null) {
                        bi.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = bi.read(buffer)) > 0) {
                fileContent.append(new String(buffer, 0, len, "ISO-8859-1"));
            }
        }
        return fileContent.toString();
    }

    public static byte[] readFile(String filePath) throws FileNotFoundException, IOException {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new FileNotFoundException(filePath);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)f.length());
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            int buf_size = 1024;
            byte[] buffer = new byte[buf_size];
            int len = 0;
            while (-1 != (len = in.read(buffer, 0, buf_size))) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bos.close();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileByClassPath(String fileClassPath) throws IOException {
        Reader reader = null;
        InputStream inputStream = null;
        StringBuffer sb = new StringBuffer("");
        char[] buffer = new char[1024];
        try {
            inputStream = FileUtil.class.getResourceAsStream(fileClassPath);
            reader = new InputStreamReader(inputStream);
            int dataLen = reader.read(buffer);
            while (dataLen >= 0) {
                sb.append(new String(buffer, 0, dataLen));
                dataLen = reader.read(buffer);
            }
        }
        finally {
            try {
                inputStream.close();
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream is) throws IOException {
        InputStreamReader reader = null;
        StringBuffer sb = new StringBuffer("");
        char[] buffer = new char[1024];
        try {
            reader = new InputStreamReader(is);
            int dataLen = reader.read(buffer);
            while (dataLen >= 0) {
                sb.append(new String(buffer, 0, dataLen));
                dataLen = reader.read(buffer);
            }
        }
        finally {
            try {
                is.close();
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static byte[] loadFile(String file) {
        byte[] key = null;
        try {
            FileInputStream in = new FileInputStream(file);
            key = new byte[in.available()];
            in.read(key);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    public static void delDir(File dir) {
        if (null != dir) {
            if (dir.isDirectory()) {
                String[] childrens = dir.list();
                for (int i = 0; i < childrens.length; ++i) {
                    FileUtil.delDir(new File(dir, childrens[i]));
                }
            }
            dir.delete();
        }
    }

    public static Properties getProperties(File f) throws IOException {
        return FileUtil.getProperties(f, defaultEncoding);
    }

    public static Properties getProperties(File f, String encoding) throws IOException {
        return FileUtil.getProperties(new FileInputStream(f), encoding);
    }

    public static Properties getProperties(InputStream is) throws IOException {
        return FileUtil.getProperties(is, defaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream is, String encoding) throws IOException {
        Reader reader = null;
        Properties p = null;
        try {
            p = new Properties();
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            p.load(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return p;
    }

    public static String getHash(String fileName) {
        return FileUtil.getHash(fileName, HASH_TYPE);
    }

    public static String getHash(File f) {
        return FileUtil.getHash(f, HASH_TYPE);
    }

    public static String getHash(String fileName, String hashType) {
        return FileUtil.getHash(new File(fileName), hashType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHash(File f, String hashType) {
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        byte[] b = null;
        byte[] buffer = new byte[1024];
        try {
            fis = new FileInputStream(f);
            MessageDigest md5 = MessageDigest.getInstance(hashType);
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            b = md5.digest();
        }
        catch (Exception md5) {
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException md5) {}
        }
        String s = FileUtil.toHexString(b);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream is, OutputStream os, int bufferSize) throws IOException {
        try {
            int bytesRead;
            byte[] buff = new byte[bufferSize];
            while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                os.write(buff, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void write(InputStream is, OutputStream os) throws IOException {
        FileUtil.write(is, os, 2048);
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

