/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    public static final String COMMON_STRING_DELIMITER = "\u001d";
    private static final int FONT_WIDTHHALF = 6;
    private static final int FONT_WIDTH = 12;
    private static final int MAX_VALUE = 127;

    public static boolean stringIsEmpty(String str) {
        return null == str || str.length() == 0;
    }

    public static String getGBK(String s) {
        String str = null;
        try {
            str = new String(s.getBytes("utf-8"), "gbk");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String splitByWidth(String str, int width) {
        int index;
        int w = 0;
        if (12 * str.length() <= width) {
            return str;
        }
        for (index = 0; index < str.length(); ++index) {
            w = str.charAt(index) < '\u007f' ? (w += 6) : (w += 12);
            if (w > width) break;
        }
        return str.substring(0, index - 1) + "...";
    }

    public static boolean isEmpty(String str) {
        boolean rs = true;
        if (str != null) {
            rs = "".equals(str.trim());
        }
        return rs;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isInteger(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        Pattern pat = Pattern.compile("^([0-9]*|-)[0-9]+$");
        Matcher m = pat.matcher(str);
        return m.find();
    }

    public static boolean isDouble(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        if (StringUtil.isInteger(str)) {
            return true;
        }
        Pattern pat = Pattern.compile("^([0-9]*|-)[0-9]+\\.[0-9]+$");
        Matcher m = pat.matcher(str);
        return m.find();
    }

    public static boolean stringToboolean(String str) {
        if (StringUtil.isNotEmpty(str)) {
            return "true".equals(str);
        }
        return false;
    }

    public static String formatJavaScriptContent(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        StringBuilder buffer = new StringBuilder(str.length() * 2);
        int size = str.length();
        block4: for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\'': {
                    buffer.append('\\').append(c);
                    continue block4;
                }
                case '\"': {
                    buffer.append('\\').append(c);
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String getString(String sep, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("?" + (i == count - 1 ? "" : ","));
        }
        return sb.toString();
    }

    public static String getString(String sep, String[] str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            sb.append(str[i] + (i == str.length - 1 ? "" : sep));
        }
        return sb.toString();
    }

    public static String replaceEnter(String str) {
        return StringUtil.replaceEnter(str, "<br/>");
    }

    public static String replaceEnter(String str, String str2) {
        String temp = "";
        if (str != null) {
            String str3 = str2 != null ? str2 : "<br/>";
            temp = str.replaceAll("\r\n", str3);
            temp = temp.replaceAll("\n", str3);
        }
        return temp;
    }

    public static String replaceTag(String str) {
        String temp = "";
        if (str != null) {
            temp = str.replaceAll("&", "&gt;");
            temp = temp.replaceAll("<", "&lt;");
            temp = temp.replaceAll(">", "&gt;");
            temp = temp.replaceAll(" ", "&nbsp;");
            temp = temp.replaceAll("'", "&#39;");
            temp = temp.replaceAll("\"", "&quot;");
            temp = temp.replaceAll("\r\n", "<br/>");
            temp = temp.replaceAll("\n", "<br/>");
        }
        return temp;
    }

    public static String getSubString(String str, int width) {
        int fontWidth = 12;
        int fontWidthHalf = 6;
        int w = 0;
        int index = 0;
        for (int i = 0; i < str.length(); ++i) {
            if ((w += str.charAt(i) <= '\u007f' ? fontWidthHalf : fontWidth) > width) continue;
            index = i;
        }
        return w < width ? str : str.substring(0, index) + "...";
    }
}

