/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.httpclient5;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.Closer;

class HijackingHttpRequestExecutor
extends HttpRequestExecutor {
    static final String HIJACKED_INPUT_ATTRIBUTE = "com.github.docker-java.hijackedInput";

    HijackingHttpRequestExecutor(ConnectionReuseStrategy connectionReuseStrategy) {
        super(connectionReuseStrategy);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpResponseInformationCallback informationCallback, HttpContext context) throws IOException, HttpException {
        Objects.requireNonNull(request, "HTTP request");
        Objects.requireNonNull(conn, "Client connection");
        Objects.requireNonNull(context, "HTTP context");
        InputStream hijackedInput = (InputStream)context.getAttribute(HIJACKED_INPUT_ATTRIBUTE);
        if (hijackedInput != null) {
            return this.executeHijacked(request, conn, (HttpCoreContext)context, hijackedInput);
        }
        return super.execute(request, conn, informationCallback, context);
    }

    private ClassicHttpResponse executeHijacked(ClassicHttpRequest request, HttpClientConnection conn, HttpCoreContext context, InputStream hijackedInput) throws HttpException, IOException {
        try {
            context.setSSLSession(conn.getSSLSession());
            context.setEndpointDetails(conn.getEndpointDetails());
            ProtocolVersion transportVersion = request.getVersion();
            if (transportVersion != null) {
                context.setProtocolVersion(transportVersion);
            }
            conn.sendRequestHeader(request);
            conn.sendRequestEntity(request);
            conn.flush();
            ClassicHttpResponse response = conn.receiveResponseHeader();
            if (response.getCode() != 101) {
                conn.terminateRequest(request);
                throw new ProtocolException("Expected 101 Switching Protocols, got: " + new StatusLine((HttpResponse)response));
            }
            Thread thread = new Thread(() -> {
                try {
                    BasicClassicHttpRequest fakeRequest = new BasicClassicHttpRequest("POST", "/");
                    fakeRequest.setHeader("Content-Length", (Object)Long.MAX_VALUE);
                    fakeRequest.setEntity((HttpEntity)new HijackedEntity(hijackedInput));
                    conn.sendRequestEntity((ClassicHttpRequest)fakeRequest);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            thread.setName("docker-java-httpclient5-hijacking-stream-" + System.identityHashCode(request));
            thread.setDaemon(true);
            thread.start();
            response.setCode(200);
            conn.receiveResponseEntity(response);
            return response;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            Closer.closeQuietly((Closeable)conn);
            throw ex;
        }
    }

    private static class HijackedEntity
    extends AbstractHttpEntity {
        private final InputStream inStream;

        HijackedEntity(InputStream inStream) {
            super((String)null, null, false);
            this.inStream = inStream;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            int read;
            byte[] buffer = new byte[1024];
            while ((read = this.inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, read);
                outStream.flush();
            }
        }

        public InputStream getContent() {
            return this.inStream;
        }

        public boolean isStreaming() {
            return true;
        }

        public boolean isRepeatable() {
            return false;
        }

        public void close() throws IOException {
            this.inStream.close();
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

