/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;

public enum CompareOperator implements QueryPart
{
    EQUALS("="),
    NOT_EQUALS("<>"),
    LIKE("LIKE"),
    IN("IN"),
    IS_NULL("IS NULL"),
    IS_NOT_NULL("IS NOT NULL"),
    GE(">="),
    GT(">"),
    LE("<="),
    LT("<="),
    BETWEEN("BETWEEN");

    private final String string;

    private CompareOperator(String string2) {
        this.string = string2;
    }

    @Override
    public String string(QueryOptions options) {
        return options.cased(this.string);
    }

    public static CompareOperator fromString(String str) {
        for (CompareOperator op : CompareOperator.values()) {
            if (!op.string.equalsIgnoreCase(str) && !op.name().equalsIgnoreCase(str)) continue;
            return op;
        }
        throw new RuntimeException("Unknown operator: " + str);
    }

    public String toString() {
        return "CompareOperator." + this.name() + "(string=" + this.getString() + ")";
    }

    protected String getString() {
        return this.string;
    }
}

