/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.CompareOperator;
import com.github.eikecochu.sqlbuilder.ConditionPart;
import com.github.eikecochu.sqlbuilder.ConditionValueType;
import com.github.eikecochu.sqlbuilder.Conditionable;
import com.github.eikecochu.sqlbuilder.Expression;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import java.util.ArrayList;

public class ConditionValue<T extends Conditionable<T>> {
    private final ConditionPart<T> part;
    private final CompareOperator operator;

    protected ConditionValue(ConditionPart<T> part, CompareOperator operator) {
        this.part = part;
        this.operator = operator;
    }

    public T value(Object value) {
        return this.values(value);
    }

    public T values(Object ... values) {
        return this.op(ConditionValueType.VALUE, values);
    }

    public T values(Iterable<Object> values) {
        ArrayList<Object> v = new ArrayList<Object>();
        for (Object o : values) {
            if (o == null) continue;
            v.add(o);
        }
        return this.values(v.toArray(new Object[0]));
    }

    public T col(String column) {
        return this.op(ConditionValueType.COLUMN, column);
    }

    public T expr(String expr, Object ... values) {
        return this.op(ConditionValueType.EXPRESSION, this.concatenate(expr, values));
    }

    public T expr(Expression expression) {
        if (expression.values() == null) {
            return this.expr(expression.expression(), new Object[0]);
        }
        return this.expr(expression.expression(), expression.values().toArray());
    }

    public T all(QueryBuilder<?> parent) {
        return this.op(ConditionValueType.ALL, parent);
    }

    public T any(QueryBuilder<?> parent) {
        return this.op(ConditionValueType.ANY, parent);
    }

    private T op(ConditionValueType type, Object ... values) {
        return this.part.condition(this.operator, type, this.removeNull(values));
    }

    private Object[] concatenate(Object a, Object[] b) {
        if (b == null || b.length == 0) {
            Object[] objectArray;
            if (a == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = a;
            }
            return objectArray;
        }
        if (a == null) {
            return b;
        }
        int bLen = b.length;
        Object[] c = new Object[1 + bLen];
        c[0] = a;
        System.arraycopy(b, 0, c, 1, bLen);
        return c;
    }

    private Object[] removeNull(Object[] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        ArrayList<Object> nonNull = new ArrayList<Object>(a.length);
        for (Object o : a) {
            if (o == null) continue;
            nonNull.add(o);
        }
        if (nonNull.size() == a.length) {
            return a;
        }
        return nonNull.toArray();
    }

    public String toString() {
        return "ConditionValue(part=" + this.getPart() + ", operator=" + this.getOperator() + ")";
    }

    protected ConditionPart<T> getPart() {
        return this.part;
    }

    protected CompareOperator getOperator() {
        return this.operator;
    }
}

