/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeGroupBy;
import com.github.eikecochu.sqlbuilder.BeforeJoin;
import com.github.eikecochu.sqlbuilder.BeforeOrderBy;
import com.github.eikecochu.sqlbuilder.BeforeUnion;
import com.github.eikecochu.sqlbuilder.BeforeWhere;
import com.github.eikecochu.sqlbuilder.Conditionable;
import com.github.eikecochu.sqlbuilder.JoinMode;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;

public class Join
extends Conditionable<Join>
implements QueryBuilder<Join>,
BeforeJoin<Join>,
BeforeWhere<Join>,
BeforeGroupBy<Join>,
BeforeOrderBy<Join>,
BeforeUnion<Join> {
    private final JoinMode joinMode;
    private QueryBuilder<?> subquery;
    private String name;

    protected Join(BeforeJoin<?> parent) {
        this(parent, JoinMode.INNER_JOIN);
    }

    protected Join(BeforeJoin<?> parent, JoinMode joinMode) {
        super(parent);
        this.joinMode = joinMode;
    }

    public Join subquery(QueryBuilder<?> subquery, String name) {
        this.subquery = subquery;
        this.name = name;
        return this;
    }

    public Join table(String name) {
        this.subquery = null;
        this.name = name;
        return this;
    }

    public Conditionable<Join> on() {
        return this;
    }

    public Join onColsEq(String col1, String col2) {
        return this.on().colsEq(col1, col2);
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else if (this.name != null) {
            strings.add(options.padCased(this.joinMode.string(options)));
            if (this.subquery != null) {
                strings.add(" ");
                strings.add(this.subquery.string(options));
            }
            strings.add(" ");
            strings.add(QueryUtils.splitName(options, this.name).string(options));
            String condition = super.string(options);
            if (condition != null) {
                strings.add(" ");
                strings.add(options.cased("ON"));
                strings.add(" ");
                strings.add(condition);
            }
        }
        return strings.toString();
    }

    @Override
    public String toString() {
        return "Join(joinMode=" + this.joinMode + ", subquery=" + this.subquery + ", name=" + this.name + ")";
    }

    protected Join subquery(QueryBuilder<?> subquery) {
        this.subquery = subquery;
        return this;
    }

    protected Join name(String name) {
        this.name = name;
        return this;
    }
}

