/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.Delete;
import com.github.eikecochu.sqlbuilder.Expression;
import com.github.eikecochu.sqlbuilder.Insert;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryPartLinked;
import com.github.eikecochu.sqlbuilder.Select;
import com.github.eikecochu.sqlbuilder.Update;
import com.github.eikecochu.sqlbuilder.With;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Query
extends QueryPartImpl<Query>
implements QueryBuilder<Query> {
    private QueryOptions options;

    Query(QueryPartLinked<?> parent) {
        super(parent);
    }

    public String toString() {
        return this.string();
    }

    @Override
    public String string(QueryOptions options) {
        return this.string(options, null);
    }

    public String string(QueryOptions options, Connection connection) {
        String sql = this.sql();
        if (sql == null && this.parent() != null) {
            sql = this.parent().string(this.safeOptions(options));
        }
        if (options.sqlPostprocessor() != null) {
            sql = options.sqlPostprocessor().process(sql, this.safeOptions(options), connection);
        }
        return sql;
    }

    public PreparedStatement prepare(Connection connection) throws SQLException {
        return this.prepare(connection, this.options);
    }

    public PreparedStatement prepare(Connection connection, QueryOptions options) throws SQLException {
        if (this.isExpression()) {
            throw new RuntimeException("use prepareCall() to prepare function calls");
        }
        options = this.safeOptions(options).prepare(true);
        String sql = this.string(options, connection).trim();
        PreparedStatement stmt = options.returnGeneratedKeys() ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);
        stmt = options.applyStatementOptions(stmt);
        if (options.stmtPostprocessor() != null) {
            stmt = options.stmtPostprocessor().process(stmt, this.safeOptions(options), connection);
        }
        int index = 1;
        for (Object value : options.preparedValues()) {
            stmt.setObject(index++, value);
        }
        return stmt;
    }

    public CallableStatement prepareCall(Connection connection, QueryOptions options) throws SQLException {
        if (!this.isExpression()) {
            throw new RuntimeException("use prepare() to prepare query statements");
        }
        options = this.safeOptions(options).prepare(true);
        String sql = this.string(options, connection).trim();
        CallableStatement stmt = connection.prepareCall(sql);
        stmt = options.applyStatementOptions(stmt);
        if (options.callPostprocessor() != null) {
            stmt = options.callPostprocessor().process(stmt, this.safeOptions(options), connection);
        }
        int index = 1;
        Expression expr = (Expression)this.parent();
        if (expr.returnType() != 0) {
            stmt.registerOutParameter(index++, expr.returnType());
        }
        for (Object value : options.preparedValues()) {
            stmt.setObject(index++, value);
        }
        int paramOffset = expr.returnType() == 0 ? 1 : 2;
        for (int type : expr.paramTypes()) {
            if (type != 0) {
                stmt.registerOutParameter(paramOffset, type);
            }
            ++paramOffset;
        }
        return stmt;
    }

    private QueryOptions safeOptions(QueryOptions options) {
        options = options == null ? QueryOptions.getDefaultOptions() : options;
        return options.query(this);
    }

    public Class<?> statementType() {
        QueryPartLinked<Query> part;
        for (part = this; part != null && part.parent() != null && !(part.parent() instanceof With); part = part.parent()) {
        }
        if (part == null) {
            return null;
        }
        return part.getClass();
    }

    public boolean isStatementType(Class<?> clazz) {
        Class<?> type = this.statementType();
        if (clazz == null && type == null) {
            return true;
        }
        if (clazz == null ^ type == null) {
            return false;
        }
        return clazz.isAssignableFrom(type);
    }

    public boolean isSelect() {
        return this.isStatementType(Select.class);
    }

    public boolean isInsert() {
        return this.isStatementType(Insert.class);
    }

    public boolean isUpdate() {
        return this.isStatementType(Update.class);
    }

    public boolean isDelete() {
        return this.isStatementType(Delete.class);
    }

    public boolean isExpression() {
        return this.isStatementType(Expression.class);
    }

    @Override
    public Query query() {
        return this;
    }

    public QueryOptions options() {
        return this.options;
    }

    public Query options(QueryOptions options) {
        this.options = options;
        return this;
    }
}

