/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import java.util.ArrayList;
import java.util.List;

final class StringUtils {
    private StringUtils() {
    }

    public static String join(Iterable<String> it, String delim) {
        if (delim == null) {
            delim = "";
        }
        String d = "";
        StringBuilder sb = new StringBuilder();
        for (String s : it) {
            sb.append(d).append(s);
            d = delim;
        }
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        if (s == null || s.length() >= length) {
            return s;
        }
        StringBuilder sBuilder = new StringBuilder(s);
        while (sBuilder.length() < length) {
            sBuilder.insert(0, " ");
        }
        s = sBuilder.toString();
        return s;
    }

    public static String repeat(String s, int times) {
        if (times <= 0) {
            return "";
        }
        if (s == null || s.isEmpty() || times == 1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String repeat(char c, int times) {
        return StringUtils.repeat("" + c, times);
    }

    public static boolean nullOrBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static List<String> filterValues(String[] strings) {
        ArrayList<String> list = new ArrayList<String>(strings == null ? 0 : strings.length);
        if (strings != null && strings.length > 0) {
            for (String string : strings) {
                if (StringUtils.nullOrBlank(string)) continue;
                list.add(string);
            }
        }
        return list;
    }
}

