/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder.oracle;

import com.github.eikecochu.sqlbuilder.Conditionable;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPartLinked;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.oracle.StartWith;

public class ConnectBy
extends Conditionable<ConnectBy>
implements QueryBuilder<ConnectBy> {
    private boolean nocycle;

    protected ConnectBy(QueryPartLinked<?> parent) {
        super(parent);
    }

    public ConnectBy connectBy() {
        return (ConnectBy)new ConnectBy().parent((QueryPartLinked)this);
    }

    public ConnectBy cycle() {
        this.nocycle = false;
        return this;
    }

    public ConnectBy nocycle() {
        this.nocycle = true;
        return this;
    }

    public StartWith startWith() {
        return new StartWith(this);
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else {
            String condition = super.string(options);
            if (condition != null && !condition.trim().isEmpty()) {
                strings.add(options.padCased("CONNECT BY"));
                if (this.nocycle) {
                    strings.add(" NOCYCLE");
                }
                strings.add(" PRIOR");
                strings.add(" ");
                strings.add(condition);
            }
        }
        return strings.toString();
    }

    @Override
    public String toString() {
        return "ConnectBy(nocycle=" + this.nocycle() + ")";
    }

    public ConnectBy() {
    }

    protected ConnectBy nocycle(boolean nocycle) {
        this.nocycle = nocycle;
        return this;
    }
}

