/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model;

public class Change<T> {
    private final T oldValue;
    private final T newValue;
    private final Type type;

    private Change(T oldValue, T newValue, Type type) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.type = type;
    }

    public static <T> Change<T> changed(T oldValue, T newValue) {
        return new Change<T>(oldValue, newValue, Type.CHANGED);
    }

    public static <T> Change<T> added(T newValue) {
        return new Change<Object>(null, newValue, Type.ADDED);
    }

    public static <T> Change<T> removed(T oldValue) {
        return new Change<Object>(oldValue, null, Type.REMOVED);
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        ADDED,
        CHANGED,
        REMOVED;

    }
}

