/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.models.validations.ValidationResult;
import com.github.elibracha.models.validations.enums.ValidationStatus;
import com.github.elibracha.validators.Validator;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ResponseValidator
implements Validator {
    private ValidationResult result = new ValidationResult();
    private JsonNode response;

    @Override
    public boolean validate() {
        Iterator<Map.Entry<String, JsonNode>> it = this.response.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> responseScope = it.next();
            if (StringUtils.isNumeric(responseScope.getKey()) || responseScope.getKey().equals("default")) continue;
            this.result.setMessage(String.format("value \"%s\" not supported in response status", responseScope.getKey()));
            this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setResponse(tree);
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public JsonNode getResponse() {
        return this.response;
    }

    public void setResult(ValidationResult result) {
        this.result = result;
    }

    public void setResponse(JsonNode response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseValidator)) {
            return false;
        }
        ResponseValidator other = (ResponseValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        JsonNode this$response = this.getResponse();
        JsonNode other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        JsonNode $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseValidator(result=" + this.getResult() + ", response=" + this.getResponse() + ")";
    }
}

