/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.Comparable;
import com.qdesrame.openapi.diff.compare.MapKeyDiff;
import com.qdesrame.openapi.diff.compare.OpenApiDiff;
import com.qdesrame.openapi.diff.model.ChangedContent;
import com.qdesrame.openapi.diff.model.ChangedMediaType;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.utils.ChangedUtils;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class ContentDiff
implements Comparable<Content> {
    private OpenApiDiff openApiDiff;

    public ContentDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    @Override
    public boolean compare(Content left, Content right) {
        return false;
    }

    public Optional<ChangedContent> diff(Content left, Content right, DiffContext context) {
        MapKeyDiff<String, MediaType> mediaTypeDiff = MapKeyDiff.diff(left, right);
        List<String> sharedMediaTypes = mediaTypeDiff.getSharedKey();
        LinkedHashMap<String, ChangedMediaType> changedMediaTypes = new LinkedHashMap<String, ChangedMediaType>();
        for (String mediaTypeKey : sharedMediaTypes) {
            MediaType oldMediaType = (MediaType)left.get(mediaTypeKey);
            MediaType newMediaType = (MediaType)right.get(mediaTypeKey);
            ChangedMediaType changedMediaType = new ChangedMediaType(oldMediaType.getSchema(), newMediaType.getSchema(), context);
            this.openApiDiff.getSchemaDiff().diff(new HashSet<String>(), oldMediaType.getSchema(), newMediaType.getSchema(), context.copyWithRequired(true)).ifPresent(changedMediaType::setSchema);
            if (ChangedUtils.isUnchanged(changedMediaType)) continue;
            changedMediaTypes.put(mediaTypeKey, changedMediaType);
        }
        return ChangedUtils.isChanged(new ChangedContent(left, right, context).setIncreased(mediaTypeDiff.getIncreased()).setMissing(mediaTypeDiff.getMissing()).setChanged(changedMediaTypes));
    }
}

