/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.ExtensionDiff;
import com.qdesrame.openapi.diff.compare.OpenApiDiff;
import com.qdesrame.openapi.diff.model.Change;
import com.qdesrame.openapi.diff.model.Changed;
import com.qdesrame.openapi.diff.model.ChangedExtensions;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.utils.ChangedUtils;
import com.qdesrame.openapi.diff.utils.Copy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;

public class ExtensionsDiff {
    private final OpenApiDiff openApiDiff;
    private ServiceLoader<ExtensionDiff> extensionsLoader = ServiceLoader.load(ExtensionDiff.class);
    private List<ExtensionDiff> extensionsDiff = new ArrayList<ExtensionDiff>();

    public ExtensionsDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.extensionsLoader.reload();
        for (ExtensionDiff anExtensionsLoader : this.extensionsLoader) {
            this.extensionsDiff.add(anExtensionsLoader);
        }
    }

    public boolean isParentApplicable(Change.Type type, Object parent, Map<String, Object> extensions, DiffContext context) {
        if (extensions.size() == 0) {
            return true;
        }
        return extensions.entrySet().stream().map(entry -> this.executeExtension((String)entry.getKey(), extensionDiff -> extensionDiff.isParentApplicable(type, parent, entry.getValue(), context))).allMatch(aBoolean -> aBoolean.orElse(true));
    }

    public Optional<ExtensionDiff> getExtensionDiff(String name) {
        return this.extensionsDiff.stream().filter(diff -> ("x-" + diff.getName()).equals(name)).findFirst();
    }

    public <T> Optional<T> executeExtension(String name, Function<ExtensionDiff, T> predicate) {
        return this.getExtensionDiff(name).map(extensionDiff -> extensionDiff.setOpenApiDiff(this.openApiDiff)).map(predicate);
    }

    public Optional<ChangedExtensions> diff(Map<String, Object> left, Map<String, Object> right) {
        return this.diff(left, right, null);
    }

    public Optional<ChangedExtensions> diff(Map<String, Object> left, Map<String, Object> right, DiffContext context) {
        left = Copy.copyMap(left);
        right = Copy.copyMap(right);
        ChangedExtensions changedExtensions = new ChangedExtensions(left, Copy.copyMap(right), context);
        for (String key2 : left.keySet()) {
            Object leftValue = left.get(key2);
            if (right.containsKey(key2)) {
                Object rightValue = right.remove(key2);
                this.executeExtensionDiff(key2, Change.changed(leftValue, rightValue), context).filter(Changed::isDifferent).ifPresent(changed -> changedExtensions.getChanged().put(key2, (Changed)changed));
                continue;
            }
            this.executeExtensionDiff(key2, Change.removed(leftValue), context).filter(Changed::isDifferent).ifPresent(changed -> changedExtensions.getMissing().put(key2, (Changed)changed));
        }
        right.forEach((key, value) -> this.executeExtensionDiff((String)key, Change.added(value), context).filter(Changed::isDifferent).ifPresent(changed -> changedExtensions.getIncreased().put((String)key, (Changed)changed)));
        return ChangedUtils.isChanged(changedExtensions);
    }

    private Optional<Changed> executeExtensionDiff(String name, Change change, DiffContext context) {
        return this.executeExtension(name, diff -> diff.setOpenApiDiff(this.openApiDiff).diff(change, context));
    }
}

