/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.MapKeyDiff;
import com.qdesrame.openapi.diff.compare.OpenApiDiff;
import com.qdesrame.openapi.diff.model.ChangedHeader;
import com.qdesrame.openapi.diff.model.ChangedHeaders;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.utils.ChangedUtils;
import io.swagger.v3.oas.models.headers.Header;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HeadersDiff {
    private OpenApiDiff openApiDiff;

    public HeadersDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public Optional<ChangedHeaders> diff(Map<String, Header> left, Map<String, Header> right, DiffContext context) {
        MapKeyDiff<String, Header> headerMapDiff = MapKeyDiff.diff(left, right);
        List<String> sharedHeaderKeys = headerMapDiff.getSharedKey();
        LinkedHashMap<String, ChangedHeader> changed = new LinkedHashMap<String, ChangedHeader>();
        for (String headerKey : sharedHeaderKeys) {
            Header oldHeader = left.get(headerKey);
            Header newHeader = right.get(headerKey);
            this.openApiDiff.getHeaderDiff().diff(oldHeader, newHeader, context).ifPresent(changedHeader -> changed.put(headerKey, (ChangedHeader)changedHeader));
        }
        return ChangedUtils.isChanged(new ChangedHeaders(left, right, context).setIncreased(headerMapDiff.getIncreased()).setMissing(headerMapDiff.getMissing()).setChanged(changed));
    }
}

