/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.OpenApiDiff;
import com.qdesrame.openapi.diff.model.ChangedPath;
import com.qdesrame.openapi.diff.model.ChangedPaths;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.utils.ChangedUtils;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathsDiff {
    private static final String REGEX_PATH = "\\{([^/]+)\\}";
    private OpenApiDiff openApiDiff;

    public PathsDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static String normalizePath(String path) {
        return path.replaceAll(REGEX_PATH, "{}");
    }

    private static List<String> extractParameters(String path) {
        ArrayList<String> params = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGEX_PATH);
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            params.add(matcher.group(1));
        }
        return params;
    }

    public Optional<ChangedPaths> diff(Map<String, PathItem> left, Map<String, PathItem> right) {
        ChangedPaths changedPaths = new ChangedPaths(left, right);
        changedPaths.getIncreased().putAll(right);
        left.keySet().forEach(url -> {
            PathItem leftPath = (PathItem)left.get(url);
            String template = PathsDiff.normalizePath(url);
            Optional<String> result = right.keySet().stream().filter(s -> PathsDiff.normalizePath(s).equals(template)).findFirst();
            if (result.isPresent()) {
                if (!changedPaths.getIncreased().containsKey(result.get())) {
                    throw new IllegalArgumentException("Two path items have the same signature: " + template);
                }
                PathItem rightPath = changedPaths.getIncreased().remove(result.get());
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                if (!url.equals(result.get())) {
                    List<String> oldParams = PathsDiff.extractParameters(url);
                    List<String> newParams = PathsDiff.extractParameters(result.get());
                    for (int i = 0; i < oldParams.size(); ++i) {
                        params.put(oldParams.get(i), newParams.get(i));
                    }
                }
                DiffContext context = new DiffContext();
                context.setUrl((String)url);
                context.setParameters(params);
                this.openApiDiff.getPathDiff().diff(leftPath, rightPath, context).ifPresent(path -> changedPaths.getChanged().put((String)result.get(), (ChangedPath)path));
            } else {
                changedPaths.getMissing().put((String)url, leftPath);
            }
        });
        return ChangedUtils.isChanged(changedPaths);
    }

    public static Paths valOrEmpty(Paths path) {
        if (path == null) {
            path = new Paths();
        }
        return path;
    }
}

