/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.CacheKey;
import com.qdesrame.openapi.diff.model.DiffContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public abstract class ReferenceDiffCache<C, D> {
    private Map<CacheKey, D> refDiffMap = new HashMap<CacheKey, D>();

    private Optional<D> getFromCache(CacheKey cacheKey) {
        return Optional.ofNullable(this.refDiffMap.get(cacheKey));
    }

    private void addToCache(CacheKey cacheKey, D changed) {
        this.refDiffMap.put(cacheKey, changed);
    }

    public Optional<D> cachedDiff(HashSet<String> refSet, C left, C right, String leftRef, String rightRef, DiffContext context) {
        boolean areBothRefParameters;
        boolean bl = areBothRefParameters = leftRef != null && rightRef != null;
        if (areBothRefParameters) {
            CacheKey key = new CacheKey(leftRef, rightRef, context);
            Optional<D> changedFromRef = this.getFromCache(key);
            if (changedFromRef.isPresent()) {
                return changedFromRef;
            }
            String refKey = this.getRefKey(leftRef, rightRef);
            if (refSet.contains(refKey)) {
                return Optional.empty();
            }
            refSet.add(refKey);
            Optional<D> changed = this.computeDiff(refSet, left, right, context);
            this.addToCache(key, changed.orElse(null));
            refSet.remove(refKey);
            return changed;
        }
        return this.computeDiff(refSet, left, right, context);
    }

    protected String getRefKey(String leftRef, String rightRef) {
        return leftRef + ":" + rightRef;
    }

    protected abstract Optional<D> computeDiff(HashSet<String> var1, C var2, C var3, DiffContext var4);
}

