/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.OpenApiDiff;
import com.qdesrame.openapi.diff.model.ChangedSecurityRequirement;
import com.qdesrame.openapi.diff.model.ChangedSecurityScheme;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.utils.ChangedUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SecurityRequirementDiff {
    private OpenApiDiff openApiDiff;
    private Components leftComponents;
    private Components rightComponents;

    public SecurityRequirementDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public static SecurityRequirement getCopy(LinkedHashMap<String, List<String>> right) {
        SecurityRequirement newSecurityRequirement = new SecurityRequirement();
        right.entrySet().stream().forEach(e -> newSecurityRequirement.put((String)e.getKey(), new ArrayList((Collection)e.getValue())));
        return newSecurityRequirement;
    }

    private LinkedHashMap<String, List<String>> contains(SecurityRequirement right, String schemeRef) {
        SecurityScheme leftSecurityScheme = this.leftComponents.getSecuritySchemes().get(schemeRef);
        LinkedHashMap<String, List<String>> found = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : right.entrySet()) {
            SecurityScheme rightSecurityScheme = this.rightComponents.getSecuritySchemes().get(entry.getKey());
            if (leftSecurityScheme.getType() != rightSecurityScheme.getType()) continue;
            switch (leftSecurityScheme.getType()) {
                case APIKEY: {
                    if (!leftSecurityScheme.getName().equals(rightSecurityScheme.getName())) break;
                    found.put((String)entry.getKey(), (List)entry.getValue());
                    return found;
                }
                case OAUTH2: 
                case HTTP: 
                case OPENIDCONNECT: {
                    found.put((String)entry.getKey(), (List)entry.getValue());
                    return found;
                }
            }
        }
        return found;
    }

    public Optional<ChangedSecurityRequirement> diff(SecurityRequirement left, SecurityRequirement right, DiffContext context) {
        ChangedSecurityRequirement changedSecurityRequirement = new ChangedSecurityRequirement(left, right != null ? SecurityRequirementDiff.getCopy(right) : null);
        left = left == null ? new SecurityRequirement() : left;
        right = right == null ? new SecurityRequirement() : right;
        for (String leftSchemeRef : left.keySet()) {
            LinkedHashMap<String, List<String>> rightSec = this.contains(right, leftSchemeRef);
            if (rightSec.isEmpty()) {
                changedSecurityRequirement.addMissing(leftSchemeRef, (List)left.get(leftSchemeRef));
                continue;
            }
            String rightSchemeRef = (String)rightSec.keySet().stream().findFirst().get();
            right.remove(rightSchemeRef);
            Optional<ChangedSecurityScheme> diff = this.openApiDiff.getSecuritySchemeDiff().diff(leftSchemeRef, (List)left.get(leftSchemeRef), rightSchemeRef, rightSec.get(rightSchemeRef), context);
            diff.ifPresent(changedSecurityRequirement::addChanged);
        }
        right.forEach(changedSecurityRequirement::addIncreased);
        return ChangedUtils.isChanged(changedSecurityRequirement);
    }
}

