/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.compare;

import com.qdesrame.openapi.diff.compare.OpenApiDiff;
import com.qdesrame.openapi.diff.compare.SecurityRequirementDiff;
import com.qdesrame.openapi.diff.model.ChangedSecurityRequirement;
import com.qdesrame.openapi.diff.model.ChangedSecurityRequirements;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.utils.ChangedUtils;
import com.qdesrame.openapi.diff.utils.RefPointer;
import com.qdesrame.openapi.diff.utils.RefType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SecurityRequirementsDiff {
    private OpenApiDiff openApiDiff;
    private Components leftComponents;
    private Components rightComponents;
    private static RefPointer<SecurityScheme> refPointer = new RefPointer(RefType.SECURITY_SCHEMES);

    public SecurityRequirementsDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public Optional<SecurityRequirement> contains(List<SecurityRequirement> securityRequirements, SecurityRequirement left) {
        return securityRequirements.stream().filter(rightSecurities -> this.same(left, (SecurityRequirement)rightSecurities)).findFirst();
    }

    public boolean same(SecurityRequirement left, SecurityRequirement right) {
        List<Pair<SecurityScheme.Type, SecurityScheme.In>> leftTypes = this.getListOfSecuritySchemes(this.leftComponents, left);
        List<Pair<SecurityScheme.Type, SecurityScheme.In>> rightTypes = this.getListOfSecuritySchemes(this.rightComponents, right);
        return CollectionUtils.isEqualCollection(leftTypes, rightTypes);
    }

    private List<Pair<SecurityScheme.Type, SecurityScheme.In>> getListOfSecuritySchemes(Components components, SecurityRequirement securityRequirement) {
        return securityRequirement.keySet().stream().map(x -> {
            SecurityScheme result = components.getSecuritySchemes().get(x);
            if (result == null) {
                throw new IllegalArgumentException("Impossible to find security scheme: " + x);
            }
            return result;
        }).map(this::getPair).distinct().collect(Collectors.toList());
    }

    private Pair<SecurityScheme.Type, SecurityScheme.In> getPair(SecurityScheme securityScheme) {
        return new ImmutablePair<SecurityScheme.Type, SecurityScheme.In>(securityScheme.getType(), securityScheme.getIn());
    }

    protected Optional<ChangedSecurityRequirements> diff(List<SecurityRequirement> left, List<SecurityRequirement> right, DiffContext context) {
        left = left == null ? new ArrayList<SecurityRequirement>() : left;
        right = right == null ? new ArrayList() : this.getCopy(right);
        ChangedSecurityRequirements changedSecurityRequirements = new ChangedSecurityRequirements(left, right);
        for (SecurityRequirement leftSecurity : left) {
            Optional<SecurityRequirement> rightSecOpt = this.contains(right, leftSecurity);
            if (!rightSecOpt.isPresent()) {
                changedSecurityRequirements.addMissing(leftSecurity);
                continue;
            }
            SecurityRequirement rightSec = rightSecOpt.get();
            right.remove(rightSec);
            Optional<ChangedSecurityRequirement> diff = this.openApiDiff.getSecurityRequirementDiff().diff(leftSecurity, rightSec, context);
            diff.ifPresent(changedSecurityRequirements::addChanged);
        }
        right.forEach(changedSecurityRequirements::addIncreased);
        return ChangedUtils.isChanged(changedSecurityRequirements);
    }

    private List<SecurityRequirement> getCopy(List<SecurityRequirement> right) {
        return right.stream().map(SecurityRequirementDiff::getCopy).collect(Collectors.toList());
    }
}

