/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.model;

import com.qdesrame.openapi.diff.model.Changed;
import com.qdesrame.openapi.diff.model.ChangedSecurityRequirement;
import com.qdesrame.openapi.diff.model.ComposedChanged;
import com.qdesrame.openapi.diff.model.DiffResult;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ChangedSecurityRequirements
implements ComposedChanged {
    private List<SecurityRequirement> oldSecurityRequirements;
    private List<SecurityRequirement> newSecurityRequirements;
    private List<SecurityRequirement> missing;
    private List<SecurityRequirement> increased;
    private List<ChangedSecurityRequirement> changed;

    public ChangedSecurityRequirements(List<SecurityRequirement> oldSecurityRequirements, List<SecurityRequirement> newSecurityRequirements) {
        this.oldSecurityRequirements = oldSecurityRequirements;
        this.newSecurityRequirements = newSecurityRequirements;
        this.changed = new ArrayList<ChangedSecurityRequirement>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (CollectionUtils.isEmpty(this.missing) && CollectionUtils.isEmpty(this.increased)) {
            return DiffResult.NO_CHANGES;
        }
        if (CollectionUtils.isEmpty(this.missing)) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public void addMissing(SecurityRequirement securityRequirement) {
        if (this.missing == null) {
            this.missing = new ArrayList<SecurityRequirement>();
        }
        this.missing.add(securityRequirement);
    }

    public void addIncreased(SecurityRequirement securityRequirement) {
        if (this.increased == null) {
            this.increased = new ArrayList<SecurityRequirement>();
        }
        this.increased.add(securityRequirement);
    }

    public void addChanged(ChangedSecurityRequirement changedSecurityRequirement) {
        if (this.changed == null) {
            this.changed = new ArrayList<ChangedSecurityRequirement>();
        }
        this.changed.add(changedSecurityRequirement);
    }

    public List<SecurityRequirement> getOldSecurityRequirements() {
        return this.oldSecurityRequirements;
    }

    public List<SecurityRequirement> getNewSecurityRequirements() {
        return this.newSecurityRequirements;
    }

    public List<SecurityRequirement> getMissing() {
        return this.missing;
    }

    public List<SecurityRequirement> getIncreased() {
        return this.increased;
    }

    public List<ChangedSecurityRequirement> getChanged() {
        return this.changed;
    }

    public ChangedSecurityRequirements setOldSecurityRequirements(List<SecurityRequirement> oldSecurityRequirements) {
        this.oldSecurityRequirements = oldSecurityRequirements;
        return this;
    }

    public ChangedSecurityRequirements setNewSecurityRequirements(List<SecurityRequirement> newSecurityRequirements) {
        this.newSecurityRequirements = newSecurityRequirements;
        return this;
    }

    public ChangedSecurityRequirements setMissing(List<SecurityRequirement> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedSecurityRequirements setIncreased(List<SecurityRequirement> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedSecurityRequirements setChanged(List<ChangedSecurityRequirement> changed) {
        this.changed = changed;
        return this;
    }
}

