/*
 * Decompiled with CFR 0.152.
 */
package com.qdesrame.openapi.diff.model.schema;

import com.qdesrame.openapi.diff.model.Changed;
import com.qdesrame.openapi.diff.model.DiffContext;
import com.qdesrame.openapi.diff.model.DiffResult;
import java.util.Objects;
import java.util.Optional;

public class ChangedReadOnly
implements Changed {
    private final DiffContext context;
    private final boolean oldValue;
    private final boolean newValue;

    public ChangedReadOnly(Boolean oldValue, Boolean newValue, DiffContext context) {
        this.context = context;
        this.oldValue = Optional.ofNullable(oldValue).orElse(false);
        this.newValue = Optional.ofNullable(newValue).orElse(false);
    }

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.oldValue, this.newValue)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.context.isResponse()) {
            return DiffResult.COMPATIBLE;
        }
        if (this.context.isRequest()) {
            if (Boolean.TRUE.equals(this.newValue)) {
                return DiffResult.INCOMPATIBLE;
            }
            return this.context.isRequired() != false ? DiffResult.INCOMPATIBLE : DiffResult.COMPATIBLE;
        }
        return DiffResult.UNKNOWN;
    }
}

