/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi.diff.ignore.ObjectMapperFactory;
import org.openapi.diff.ignore.deserializers.AbstractDeserializer;
import org.openapi.diff.ignore.models.ignore.Content;
import org.openapi.diff.ignore.models.ignore.ContentSchema;

public class ContentDeserializer
extends AbstractDeserializer<Content> {
    public ContentDeserializer() {
        super(Content.class);
    }

    @Override
    public Content deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode contentScope = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Content content = (Content)this.preProcess(new Content(), contentScope);
        HashMap<String, ContentSchema> contentSchemaMap = new HashMap<String, ContentSchema>();
        Iterator<Map.Entry<String, JsonNode>> it = contentScope.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> contentSchemaScope = it.next();
            ContentSchema contentSchemaIgnore = ObjectMapperFactory.createYaml().convertValue((Object)contentSchemaScope.getValue(), ContentSchema.class);
            if (this.checkWildCards(contentSchemaScope.getKey())) {
                for (String sup : this.extractWildCards(contentSchemaScope.getKey())) {
                    contentSchemaMap.put(sup, contentSchemaIgnore);
                }
                continue;
            }
            contentSchemaMap.put(contentSchemaScope.getKey(), contentSchemaIgnore);
        }
        content.setContentSchemas(contentSchemaMap);
        return content;
    }
}

