/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.openapi.diff.ignore.deserializers.AbstractDeserializer;
import org.openapi.diff.ignore.models.ignore.ContentProperties;

public class ContentPropertiesDeserializer
extends AbstractDeserializer<ContentProperties> {
    public ContentPropertiesDeserializer() {
        super(ContentProperties.class);
    }

    @Override
    public ContentProperties deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode contentPropertiesScope = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ContentProperties contentProperties = (ContentProperties)this.preProcess(new ContentProperties(), contentPropertiesScope);
        ArrayList<String> props = new ArrayList<String>();
        Iterator<Map.Entry<String, JsonNode>> it = contentPropertiesScope.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> propertiesScope = it.next();
            for (JsonNode prop : propertiesScope.getValue()) {
                props.add(prop.asText());
            }
        }
        contentProperties.setProperties(props);
        return contentProperties;
    }
}

