/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi.diff.ignore.ObjectMapperFactory;
import org.openapi.diff.ignore.deserializers.AbstractDeserializer;
import org.openapi.diff.ignore.models.ignore.HttpMethodIgnore;
import org.openapi.diff.ignore.models.ignore.PathsIgnore;

public class PathsDeserializer
extends AbstractDeserializer<PathsIgnore> {
    public PathsDeserializer() {
        super(PathsIgnore.class);
    }

    @Override
    public PathsIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode paths = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        PathsIgnore pathsIgnore = (PathsIgnore)this.preProcess(new PathsIgnore(), paths);
        HashMap<String, HttpMethodIgnore> map = new HashMap<String, HttpMethodIgnore>();
        Iterator<Map.Entry<String, JsonNode>> it = paths.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> pathScope = it.next();
            HttpMethodIgnore path = ObjectMapperFactory.createYaml().convertValue((Object)pathScope.getValue(), HttpMethodIgnore.class);
            if (this.checkWildCards(pathScope.getKey())) {
                for (String key : this.extractWildCards(pathScope.getKey())) {
                    map.put(key, path);
                }
                continue;
            }
            map.put(pathScope.getKey(), path);
        }
        pathsIgnore.setPaths(map);
        return pathsIgnore;
    }
}

