/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.openapi.diff.ignore.ObjectMapperFactory;
import org.openapi.diff.ignore.deserializers.AbstractDeserializer;
import org.openapi.diff.ignore.exceptions.SpecificationSupportException;
import org.openapi.diff.ignore.models.ignore.Content;
import org.openapi.diff.ignore.models.ignore.RequestIgnore;

public class RequestDeserializer
extends AbstractDeserializer<RequestIgnore> {
    public RequestDeserializer() {
        super(RequestIgnore.class);
    }

    @Override
    public RequestIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode requestScope = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        RequestIgnore requestIgnore = (RequestIgnore)this.preProcess(new RequestIgnore(), requestScope);
        Iterator<Map.Entry<String, JsonNode>> it = requestScope.fields();
        block6: while (it.hasNext()) {
            Map.Entry<String, JsonNode> requestContentScope = it.next();
            switch (requestContentScope.getKey()) {
                case "content": {
                    Content contentIgnore = ObjectMapperFactory.createYaml().convertValue((Object)requestContentScope.getValue(), Content.class);
                    requestIgnore.setContent(contentIgnore);
                    continue block6;
                }
            }
            throw new SpecificationSupportException(String.format("Specification does not support value \"%s\" as an request ignore type, please referenced the documentation for supported entries.", requestContentScope.getKey()));
        }
        return requestIgnore;
    }
}

