/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi.diff.ignore.ObjectMapperFactory;
import org.openapi.diff.ignore.deserializers.AbstractDeserializer;
import org.openapi.diff.ignore.models.ignore.SecurityIgnore;
import org.openapi.diff.ignore.models.ignore.SecurityProperty;

public class SecurityDeserializer
extends AbstractDeserializer<SecurityIgnore> {
    public SecurityDeserializer() {
        super(SecurityIgnore.class);
    }

    @Override
    public SecurityIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode securities = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        SecurityIgnore securityIgnore = (SecurityIgnore)this.preProcess(new SecurityIgnore(), securities);
        HashMap<String, SecurityProperty> requirements = new HashMap<String, SecurityProperty>();
        Iterator<Map.Entry<String, JsonNode>> it = securities.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> securityScope = it.next();
            SecurityProperty propertyIgnore = ObjectMapperFactory.createYaml().convertValue((Object)securityScope.getValue(), SecurityProperty.class);
            requirements.put(securityScope.getKey(), propertyIgnore);
        }
        securityIgnore.setSecurity(requirements);
        return securityIgnore;
    }
}

