/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.processors;

import com.qdesrame.openapi.diff.model.ChangedOpenApi;
import com.qdesrame.openapi.diff.model.ChangedOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import org.openapi.diff.ignore.ContextMapKey;
import org.openapi.diff.ignore.exceptions.SpecificationSupportException;
import org.openapi.diff.ignore.models.OpenApiIgnore;
import org.openapi.diff.ignore.processors.PathsProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ContextProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private final ContextMapKey<String, String> mapKey = new ContextMapKey();
    private final PathsProcessor pathsProcessor = new PathsProcessor();
    private String ignorePath;

    public ContextProcessor() {
        this.ignorePath = ".diffignore";
    }

    public ContextProcessor(String ignorePath) {
        this.ignorePath = ignorePath;
    }

    public ChangedOpenApi process(ChangedOpenApi changedOpenApi) throws SpecificationSupportException {
        boolean result = false;
        try (FileInputStream inputStream = new FileInputStream(new File(this.ignorePath));){
            Yaml yaml = new Yaml();
            result = this.mapKey.load((Map)yaml.load(inputStream));
        }
        catch (IOException | YAMLException e) {
            log.error(e.getMessage());
            System.exit(1);
        }
        OpenApiIgnore openApiIgnore = new OpenApiIgnore(result, this.mapKey.getContextIgnore());
        return this.apply(changedOpenApi, openApiIgnore);
    }

    private ChangedOpenApi apply(ChangedOpenApi changedOpenApi, OpenApiIgnore openApiIgnore) throws SpecificationSupportException {
        if (!openApiIgnore.isValidIgnore()) {
            throw new SpecificationSupportException("Invalid Ignore");
        }
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        ArrayList<ChangedOperation> toRemove = new ArrayList<ChangedOperation>();
        for (ChangedOperation changedOperation : changedOpenApi.getChangedOperations()) {
            boolean result = this.pathsProcessor.apply(changedOperation, openApiIgnore.getIgnore().getPaths(), antPathMatcher);
            if (!result) continue;
            toRemove.add(changedOperation);
        }
        changedOpenApi.getChangedOperations().removeAll(toRemove);
        return changedOpenApi;
    }

    public ContextMapKey<String, String> getMapKey() {
        return this.mapKey;
    }

    public PathsProcessor getPathsProcessor() {
        return this.pathsProcessor;
    }

    public String getIgnorePath() {
        return this.ignorePath;
    }

    public void setIgnorePath(String ignorePath) {
        this.ignorePath = ignorePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextProcessor)) {
            return false;
        }
        ContextProcessor other = (ContextProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContextMapKey<String, String> this$mapKey = this.getMapKey();
        ContextMapKey<String, String> other$mapKey = other.getMapKey();
        if (this$mapKey == null ? other$mapKey != null : !this$mapKey.equals(other$mapKey)) {
            return false;
        }
        PathsProcessor this$pathsProcessor = this.getPathsProcessor();
        PathsProcessor other$pathsProcessor = other.getPathsProcessor();
        if (this$pathsProcessor == null ? other$pathsProcessor != null : !this$pathsProcessor.equals(other$pathsProcessor)) {
            return false;
        }
        String this$ignorePath = this.getIgnorePath();
        String other$ignorePath = other.getIgnorePath();
        return !(this$ignorePath == null ? other$ignorePath != null : !this$ignorePath.equals(other$ignorePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContextMapKey<String, String> $mapKey = this.getMapKey();
        result = result * 59 + ($mapKey == null ? 43 : $mapKey.hashCode());
        PathsProcessor $pathsProcessor = this.getPathsProcessor();
        result = result * 59 + ($pathsProcessor == null ? 43 : $pathsProcessor.hashCode());
        String $ignorePath = this.getIgnorePath();
        result = result * 59 + ($ignorePath == null ? 43 : $ignorePath.hashCode());
        return result;
    }

    public String toString() {
        return "ContextProcessor(mapKey=" + this.getMapKey() + ", pathsProcessor=" + this.getPathsProcessor() + ", ignorePath=" + this.getIgnorePath() + ")";
    }
}

