/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.processors;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.invoke.MethodHandles;
import org.openapi.diff.ignore.validators.ContextValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private final ContextValidator contextIgnoreValidator = new ContextValidator();

    public boolean validate(JsonNode ignore) {
        this.contextIgnoreValidator.setIgnore(ignore);
        if (this.contextIgnoreValidator.validate()) {
            return true;
        }
        log.error(String.format("%s: %s - %s", this.contextIgnoreValidator.getResult().getValidationStatus().getStatus(), this.contextIgnoreValidator.getResult().getValidationStatus().getMessage(), this.contextIgnoreValidator.getResult().getMessage()));
        return false;
    }

    public ContextValidator getContextIgnoreValidator() {
        return this.contextIgnoreValidator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationProcessor)) {
            return false;
        }
        ValidationProcessor other = (ValidationProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContextValidator this$contextIgnoreValidator = this.getContextIgnoreValidator();
        ContextValidator other$contextIgnoreValidator = other.getContextIgnoreValidator();
        return !(this$contextIgnoreValidator == null ? other$contextIgnoreValidator != null : !((Object)this$contextIgnoreValidator).equals(other$contextIgnoreValidator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContextValidator $contextIgnoreValidator = this.getContextIgnoreValidator();
        result = result * 59 + ($contextIgnoreValidator == null ? 43 : ((Object)$contextIgnoreValidator).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationProcessor(contextIgnoreValidator=" + this.getContextIgnoreValidator() + ")";
    }
}

