/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.validators;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapi.diff.ignore.models.SpecConstants;
import org.openapi.diff.ignore.models.validations.ValidationResult;
import org.openapi.diff.ignore.models.validations.enums.ContextSupport;
import org.openapi.diff.ignore.models.validations.enums.ValidationStatus;
import org.openapi.diff.ignore.validators.PathValidator;
import org.openapi.diff.ignore.validators.Validator;

public class ContextValidator
implements Validator {
    private final ValidationResult result = new ValidationResult();
    private final PathValidator pathValidator = new PathValidator();
    private JsonNode ignore;

    @Override
    public boolean validate() {
        List supported = Arrays.stream(ContextSupport.values()).map(ContextSupport::getValue).collect(Collectors.toList());
        Iterator<Map.Entry<String, JsonNode>> it = this.ignore.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> contextScope = it.next();
            if (supported.contains(contextScope.getKey())) continue;
            this.result.setMessage(String.format("value \"%s\" not supported", contextScope.getKey()));
            this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
            return false;
        }
        if (this.ignore.get("version") != null) {
            if (!SpecConstants.VERSIONS.contains(this.ignore.get("version").asText())) {
                this.result.setMessage(String.format("version not supported \"%s\"", this.ignore.get("version")));
                this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
                return false;
            }
        } else {
            this.result.setMessage("version spec must be present in ignore file.");
            this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
            return false;
        }
        if (this.ignore.get("paths") != null) {
            this.pathValidator.setPaths(this.ignore.get("paths"));
            boolean r = this.pathValidator.validate();
            this.result.setValidationStatus(this.pathValidator.getResult().getValidationStatus());
            this.result.setMessage(this.pathValidator.getResult().getMessage());
            return r;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setIgnore(tree);
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public PathValidator getPathValidator() {
        return this.pathValidator;
    }

    public JsonNode getIgnore() {
        return this.ignore;
    }

    public void setIgnore(JsonNode ignore) {
        this.ignore = ignore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextValidator)) {
            return false;
        }
        ContextValidator other = (ContextValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        PathValidator this$pathValidator = this.getPathValidator();
        PathValidator other$pathValidator = other.getPathValidator();
        if (this$pathValidator == null ? other$pathValidator != null : !((Object)this$pathValidator).equals(other$pathValidator)) {
            return false;
        }
        JsonNode this$ignore = this.getIgnore();
        JsonNode other$ignore = other.getIgnore();
        return !(this$ignore == null ? other$ignore != null : !((Object)this$ignore).equals(other$ignore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        PathValidator $pathValidator = this.getPathValidator();
        result = result * 59 + ($pathValidator == null ? 43 : ((Object)$pathValidator).hashCode());
        JsonNode $ignore = this.getIgnore();
        result = result * 59 + ($ignore == null ? 43 : $ignore.hashCode());
        return result;
    }

    public String toString() {
        return "ContextValidator(result=" + this.getResult() + ", pathValidator=" + this.getPathValidator() + ", ignore=" + this.getIgnore() + ")";
    }
}

