/*
 * Decompiled with CFR 0.152.
 */
package org.openapi.diff.ignore.validators;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapi.diff.ignore.models.validations.ValidationResult;
import org.openapi.diff.ignore.models.validations.enums.RequestSupport;
import org.openapi.diff.ignore.models.validations.enums.ValidationStatus;
import org.openapi.diff.ignore.validators.Validator;

public class RequestValidator
implements Validator {
    private final ValidationResult result = new ValidationResult();
    private JsonNode request;

    @Override
    public boolean validate() {
        List supported = Arrays.stream(RequestSupport.values()).map(RequestSupport::getValue).collect(Collectors.toList());
        Iterator<Map.Entry<String, JsonNode>> it = this.request.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> requestScope = it.next();
            if (supported.contains(requestScope.getKey())) continue;
            this.result.setMessage(String.format("value \"%s\" not supported in request", requestScope.getKey()));
            this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setRequest(tree);
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public JsonNode getRequest() {
        return this.request;
    }

    public void setRequest(JsonNode request) {
        this.request = request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestValidator)) {
            return false;
        }
        RequestValidator other = (RequestValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        JsonNode this$request = this.getRequest();
        JsonNode other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        JsonNode $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    public String toString() {
        return "RequestValidator(result=" + this.getResult() + ", request=" + this.getRequest() + ")";
    }
}

