/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.model.ChangedOAuthFlows;
import com.github.elibracha.utils.ChangedUtils;
import io.swagger.v3.oas.models.security.OAuthFlows;
import java.util.Map;
import java.util.Optional;

public class OAuthFlowsDiff {
    private OpenApiDiff openApiDiff;

    public OAuthFlowsDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static Map<String, Object> getExtensions(OAuthFlows oAuthFlow) {
        return Optional.ofNullable(oAuthFlow).map(OAuthFlows::getExtensions).orElse(null);
    }

    public Optional<ChangedOAuthFlows> diff(OAuthFlows left, OAuthFlows right) {
        ChangedOAuthFlows changedOAuthFlows = new ChangedOAuthFlows(left, right);
        if (left != null && right != null) {
            this.openApiDiff.getOAuthFlowDiff().diff(left.getImplicit(), right.getImplicit()).ifPresent(changedOAuthFlows::setImplicitOAuthFlow);
            this.openApiDiff.getOAuthFlowDiff().diff(left.getPassword(), right.getPassword()).ifPresent(changedOAuthFlows::setPasswordOAuthFlow);
            this.openApiDiff.getOAuthFlowDiff().diff(left.getClientCredentials(), right.getClientCredentials()).ifPresent(changedOAuthFlows::setClientCredentialOAuthFlow);
            this.openApiDiff.getOAuthFlowDiff().diff(left.getAuthorizationCode(), right.getAuthorizationCode()).ifPresent(changedOAuthFlows::setAuthorizationCodeOAuthFlow);
        }
        this.openApiDiff.getExtensionsDiff().diff(OAuthFlowsDiff.getExtensions(left), OAuthFlowsDiff.getExtensions(right)).ifPresent(changedOAuthFlows::setExtensions);
        return ChangedUtils.isChanged(changedOAuthFlows);
    }
}

