/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.ApiResponseDiff;
import com.github.elibracha.compare.ContentDiff;
import com.github.elibracha.compare.ExtensionsDiff;
import com.github.elibracha.compare.HeaderDiff;
import com.github.elibracha.compare.HeadersDiff;
import com.github.elibracha.compare.MetadataDiff;
import com.github.elibracha.compare.OAuthFlowDiff;
import com.github.elibracha.compare.OAuthFlowsDiff;
import com.github.elibracha.compare.OperationDiff;
import com.github.elibracha.compare.ParameterDiff;
import com.github.elibracha.compare.ParametersDiff;
import com.github.elibracha.compare.PathDiff;
import com.github.elibracha.compare.PathsDiff;
import com.github.elibracha.compare.RequestBodyDiff;
import com.github.elibracha.compare.ResponseDiff;
import com.github.elibracha.compare.SchemaDiff;
import com.github.elibracha.compare.SecurityRequirementDiff;
import com.github.elibracha.compare.SecurityRequirementsDiff;
import com.github.elibracha.compare.SecuritySchemeDiff;
import com.github.elibracha.model.ChangedExtensions;
import com.github.elibracha.model.ChangedOpenApi;
import com.github.elibracha.model.ChangedOperation;
import com.github.elibracha.model.ChangedPath;
import com.github.elibracha.model.ChangedPaths;
import com.github.elibracha.model.Endpoint;
import com.github.elibracha.utils.EndpointUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiDiff {
    public static final String SWAGGER_VERSION_V2 = "2.0";
    private static Logger logger = LoggerFactory.getLogger(OpenApiDiff.class);
    private PathsDiff pathsDiff;
    private PathDiff pathDiff;
    private SchemaDiff schemaDiff;
    private ContentDiff contentDiff;
    private ParametersDiff parametersDiff;
    private ParameterDiff parameterDiff;
    private RequestBodyDiff requestBodyDiff;
    private ResponseDiff responseDiff;
    private HeadersDiff headersDiff;
    private HeaderDiff headerDiff;
    private ApiResponseDiff apiResponseDiff;
    private OperationDiff operationDiff;
    private SecurityRequirementsDiff securityRequirementsDiff;
    private SecurityRequirementDiff securityRequirementDiff;
    private SecuritySchemeDiff securitySchemeDiff;
    private OAuthFlowsDiff oAuthFlowsDiff;
    private OAuthFlowDiff oAuthFlowDiff;
    private ExtensionsDiff extensionsDiff;
    private MetadataDiff metadataDiff;
    private OpenAPI oldSpecOpenApi;
    private OpenAPI newSpecOpenApi;
    private List<Endpoint> newEndpoints;
    private List<Endpoint> missingEndpoints;
    private List<ChangedOperation> changedOperations;
    private ChangedExtensions changedExtensions;

    private OpenApiDiff(OpenAPI oldSpecOpenApi, OpenAPI newSpecOpenApi) {
        this.oldSpecOpenApi = oldSpecOpenApi;
        this.newSpecOpenApi = newSpecOpenApi;
        if (null == oldSpecOpenApi || null == newSpecOpenApi) {
            throw new RuntimeException("one of the old or new object is null");
        }
        this.initializeFields();
    }

    public static ChangedOpenApi compare(OpenAPI oldSpec, OpenAPI newSpec) {
        return new OpenApiDiff(oldSpec, newSpec).compare();
    }

    private void initializeFields() {
        this.pathsDiff = new PathsDiff(this);
        this.pathDiff = new PathDiff(this);
        this.schemaDiff = new SchemaDiff(this);
        this.contentDiff = new ContentDiff(this);
        this.parametersDiff = new ParametersDiff(this);
        this.parameterDiff = new ParameterDiff(this);
        this.requestBodyDiff = new RequestBodyDiff(this);
        this.responseDiff = new ResponseDiff(this);
        this.headersDiff = new HeadersDiff(this);
        this.headerDiff = new HeaderDiff(this);
        this.apiResponseDiff = new ApiResponseDiff(this);
        this.operationDiff = new OperationDiff(this);
        this.securityRequirementsDiff = new SecurityRequirementsDiff(this);
        this.securityRequirementDiff = new SecurityRequirementDiff(this);
        this.securitySchemeDiff = new SecuritySchemeDiff(this);
        this.oAuthFlowsDiff = new OAuthFlowsDiff(this);
        this.oAuthFlowDiff = new OAuthFlowDiff(this);
        this.extensionsDiff = new ExtensionsDiff(this);
        this.metadataDiff = new MetadataDiff(this);
    }

    private ChangedOpenApi compare() {
        this.preProcess(this.oldSpecOpenApi);
        this.preProcess(this.newSpecOpenApi);
        Optional<ChangedPaths> paths = this.pathsDiff.diff(PathsDiff.valOrEmpty(this.oldSpecOpenApi.getPaths()), PathsDiff.valOrEmpty(this.newSpecOpenApi.getPaths()));
        this.newEndpoints = new ArrayList<Endpoint>();
        this.missingEndpoints = new ArrayList<Endpoint>();
        this.changedOperations = new ArrayList<ChangedOperation>();
        paths.ifPresent(changedPaths -> {
            this.newEndpoints = EndpointUtils.convert2EndpointList(changedPaths.getIncreased());
            this.missingEndpoints = EndpointUtils.convert2EndpointList(changedPaths.getMissing());
            changedPaths.getChanged().keySet().forEach(path -> {
                ChangedPath changedPath = changedPaths.getChanged().get(path);
                this.newEndpoints.addAll(EndpointUtils.convert2Endpoints(path, changedPath.getIncreased()));
                this.missingEndpoints.addAll(EndpointUtils.convert2Endpoints(path, changedPath.getMissing()));
                this.changedOperations.addAll(changedPath.getChanged());
            });
        });
        this.getExtensionsDiff().diff(this.oldSpecOpenApi.getExtensions(), this.newSpecOpenApi.getExtensions()).ifPresent(this::setChangedExtension);
        return this.getChangedOpenApi();
    }

    private void setChangedExtension(ChangedExtensions changedExtension) {
        this.changedExtensions = changedExtension;
    }

    private void preProcess(OpenAPI openApi) {
        List<SecurityRequirement> securityRequirements = openApi.getSecurity();
        if (securityRequirements != null) {
            List distinctSecurityRequirements = securityRequirements.stream().distinct().collect(Collectors.toList());
            Paths paths = openApi.getPaths();
            if (paths != null) {
                paths.values().forEach(pathItem -> pathItem.readOperationsMap().values().stream().filter(operation -> operation.getSecurity() != null).forEach(operation -> operation.setSecurity(operation.getSecurity().stream().distinct().collect(Collectors.toList()))));
                paths.values().forEach(pathItem -> pathItem.readOperationsMap().values().stream().filter(operation -> operation.getSecurity() == null).forEach(operation -> operation.setSecurity(distinctSecurityRequirements)));
            }
            openApi.setSecurity(null);
        }
    }

    private ChangedOpenApi getChangedOpenApi() {
        return new ChangedOpenApi().setMissingEndpoints(this.missingEndpoints).setNewEndpoints(this.newEndpoints).setNewSpecOpenApi(this.newSpecOpenApi).setOldSpecOpenApi(this.oldSpecOpenApi).setChangedOperations(this.changedOperations).setChangedExtensions(this.changedExtensions);
    }

    public PathsDiff getPathsDiff() {
        return this.pathsDiff;
    }

    public PathDiff getPathDiff() {
        return this.pathDiff;
    }

    public SchemaDiff getSchemaDiff() {
        return this.schemaDiff;
    }

    public ContentDiff getContentDiff() {
        return this.contentDiff;
    }

    public ParametersDiff getParametersDiff() {
        return this.parametersDiff;
    }

    public ParameterDiff getParameterDiff() {
        return this.parameterDiff;
    }

    public RequestBodyDiff getRequestBodyDiff() {
        return this.requestBodyDiff;
    }

    public ResponseDiff getResponseDiff() {
        return this.responseDiff;
    }

    public HeadersDiff getHeadersDiff() {
        return this.headersDiff;
    }

    public HeaderDiff getHeaderDiff() {
        return this.headerDiff;
    }

    public ApiResponseDiff getApiResponseDiff() {
        return this.apiResponseDiff;
    }

    public OperationDiff getOperationDiff() {
        return this.operationDiff;
    }

    public SecurityRequirementsDiff getSecurityRequirementsDiff() {
        return this.securityRequirementsDiff;
    }

    public SecurityRequirementDiff getSecurityRequirementDiff() {
        return this.securityRequirementDiff;
    }

    public SecuritySchemeDiff getSecuritySchemeDiff() {
        return this.securitySchemeDiff;
    }

    public OAuthFlowsDiff getOAuthFlowsDiff() {
        return this.oAuthFlowsDiff;
    }

    public OAuthFlowDiff getOAuthFlowDiff() {
        return this.oAuthFlowDiff;
    }

    public ExtensionsDiff getExtensionsDiff() {
        return this.extensionsDiff;
    }

    public MetadataDiff getMetadataDiff() {
        return this.metadataDiff;
    }

    public OpenAPI getOldSpecOpenApi() {
        return this.oldSpecOpenApi;
    }

    public OpenAPI getNewSpecOpenApi() {
        return this.newSpecOpenApi;
    }

    public List<Endpoint> getNewEndpoints() {
        return this.newEndpoints;
    }

    public List<Endpoint> getMissingEndpoints() {
        return this.missingEndpoints;
    }

    public List<ChangedOperation> getChangedOperations() {
        return this.changedOperations;
    }

    public ChangedExtensions getChangedExtensions() {
        return this.changedExtensions;
    }
}

