/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.MapKeyDiff;
import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.model.ChangedPath;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.utils.ChangedUtils;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PathDiff {
    private OpenApiDiff openApiDiff;

    public PathDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public Optional<ChangedPath> diff(PathItem left, PathItem right, DiffContext context) {
        Map<PathItem.HttpMethod, Operation> oldOperationMap = left.readOperationsMap();
        Map<PathItem.HttpMethod, Operation> newOperationMap = right.readOperationsMap();
        MapKeyDiff<PathItem.HttpMethod, Operation> operationsDiff = MapKeyDiff.diff(oldOperationMap, newOperationMap);
        List<PathItem.HttpMethod> sharedMethods = operationsDiff.getSharedKey();
        ChangedPath changedPath = new ChangedPath(context.getUrl(), left, right, context).setIncreased(operationsDiff.getIncreased()).setMissing(operationsDiff.getMissing());
        for (PathItem.HttpMethod method : sharedMethods) {
            Operation oldOperation = oldOperationMap.get((Object)method);
            Operation newOperation = newOperationMap.get((Object)method);
            this.openApiDiff.getOperationDiff().diff(oldOperation, newOperation, context.copyWithMethod(method)).ifPresent(changedPath.getChanged()::add);
        }
        this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context).ifPresent(changedPath::setExtensions);
        return ChangedUtils.isChanged(changedPath);
    }
}

