/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare.schemadiffresult;

import com.github.elibracha.compare.MapKeyDiff;
import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.compare.schemadiffresult.SchemaDiffResult;
import com.github.elibracha.model.ChangedOneOfSchema;
import com.github.elibracha.model.ChangedSchema;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.utils.RefPointer;
import com.github.elibracha.utils.RefType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ComposedSchemaDiffResult
extends SchemaDiffResult {
    private static RefPointer<Schema> refPointer = new RefPointer(RefType.SCHEMAS);

    public ComposedSchemaDiffResult(OpenApiDiff openApiDiff) {
        super(openApiDiff);
    }

    public <T extends Schema<X>, X> Optional<ChangedSchema> diff(HashSet<String> refSet, Components leftComponents, Components rightComponents, T left, T right, DiffContext context) {
        if (left instanceof ComposedSchema) {
            ComposedSchema leftComposedSchema = (ComposedSchema)left;
            ComposedSchema rightComposedSchema = (ComposedSchema)right;
            if (CollectionUtils.isNotEmpty(leftComposedSchema.getOneOf()) || CollectionUtils.isNotEmpty(rightComposedSchema.getOneOf())) {
                Discriminator leftDis = leftComposedSchema.getDiscriminator();
                Discriminator rightDis = rightComposedSchema.getDiscriminator();
                if (leftDis == null || rightDis == null || leftDis.getPropertyName() == null || rightDis.getPropertyName() == null) {
                    throw new IllegalArgumentException("discriminator or property not found for oneOf schema");
                }
                if (!leftDis.getPropertyName().equals(rightDis.getPropertyName()) || CollectionUtils.isEmpty(leftComposedSchema.getOneOf()) || CollectionUtils.isEmpty(rightComposedSchema.getOneOf())) {
                    this.changedSchema.setOldSchema(left);
                    this.changedSchema.setNewSchema(right);
                    this.changedSchema.setDiscriminatorPropertyChanged(true);
                    this.changedSchema.setContext(context);
                    return Optional.of(this.changedSchema);
                }
                Map<String, String> leftMapping = this.getMapping(leftComposedSchema);
                Map<String, String> rightMapping = this.getMapping(rightComposedSchema);
                MapKeyDiff<String, Schema> mappingDiff = MapKeyDiff.diff(this.getSchema(leftComponents, leftMapping), this.getSchema(rightComponents, rightMapping));
                LinkedHashMap<String, ChangedSchema> changedMapping = new LinkedHashMap<String, ChangedSchema>();
                for (String key : mappingDiff.getSharedKey()) {
                    Schema leftSchema = new Schema();
                    leftSchema.set$ref(leftMapping.get(key));
                    Schema rightSchema = new Schema();
                    rightSchema.set$ref(rightMapping.get(key));
                    Optional<ChangedSchema> changedSchema = this.openApiDiff.getSchemaDiff().diff(refSet, leftSchema, rightSchema, context.copyWithRequired(true));
                    changedSchema.ifPresent(schema -> changedMapping.put(key, (ChangedSchema)schema));
                }
                this.changedSchema.setOneOfSchema(new ChangedOneOfSchema(leftMapping, rightMapping, context).setIncreased(mappingDiff.getIncreased()).setMissing(mappingDiff.getMissing()).setChanged(changedMapping));
            }
            return super.diff(refSet, leftComponents, rightComponents, left, right, context);
        }
        return this.openApiDiff.getSchemaDiff().getTypeChangedSchema(left, right, context);
    }

    private Map<String, Schema> getSchema(Components components, Map<String, String> mapping) {
        LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>();
        mapping.forEach((key, value) -> result.put((String)key, refPointer.resolveRef(components, new Schema(), (String)value)));
        return result;
    }

    private Map<String, String> getMapping(ComposedSchema composedSchema) {
        LinkedHashMap<String, String> reverseMapping = new LinkedHashMap<String, String>();
        for (Schema schema : composedSchema.getOneOf()) {
            String ref = schema.get$ref();
            if (ref == null) {
                throw new IllegalArgumentException("invalid oneOf schema");
            }
            String schemaName = refPointer.getRefName(ref);
            if (schemaName == null) {
                throw new IllegalArgumentException("invalid schema: " + ref);
            }
            reverseMapping.put(ref, schemaName);
        }
        if (composedSchema.getDiscriminator().getMapping() != null) {
            for (String ref : composedSchema.getDiscriminator().getMapping().keySet()) {
                reverseMapping.put(composedSchema.getDiscriminator().getMapping().get(ref), ref);
            }
        }
        return reverseMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

