/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.ObjectMapperFactory;
import com.github.elibracha.deserializers.AbstractDeserializer;
import com.github.elibracha.exceptions.SpecificationSupportException;
import com.github.elibracha.models.ignore.ContentProperties;
import com.github.elibracha.models.ignore.ContentSchema;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ContentSchemaDeserializer
extends AbstractDeserializer<ContentSchema> {
    public ContentSchemaDeserializer() {
        super(ContentSchema.class);
    }

    @Override
    public ContentSchema deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode contentSchemaScope = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ContentSchema contentSchema = (ContentSchema)this.preProcess(new ContentSchema(), contentSchemaScope);
        Iterator<Map.Entry<String, JsonNode>> it = contentSchemaScope.fields();
        block6: while (it.hasNext()) {
            Map.Entry<String, JsonNode> contentPropertiesScope = it.next();
            switch (contentPropertiesScope.getKey()) {
                case "schema": {
                    ContentProperties contentIgnore = ObjectMapperFactory.createYaml().convertValue((Object)contentPropertiesScope.getValue(), ContentProperties.class);
                    contentSchema.setSchema(contentIgnore);
                    continue block6;
                }
            }
            throw new SpecificationSupportException(String.format("Specification does not support value \"%s\" as an schema ignore type, please referenced the documentation for supported entries.", contentPropertiesScope.getKey()));
        }
        return contentSchema;
    }
}

