/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.github.elibracha.ObjectMapperFactory;
import com.github.elibracha.exceptions.SpecificationSupportException;
import com.github.elibracha.models.ignore.ContextIgnore;
import com.github.elibracha.models.ignore.PathsIgnore;
import com.github.elibracha.processors.ValidationProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ContextDeserializer
extends StdDeserializer<ContextIgnore> {
    private static final Logger log = LoggerFactory.getLogger(ContextDeserializer.class);
    private final ValidationProcessor validationProcessor = new ValidationProcessor();
    private PathsIgnore pathsIgnore;
    private PathsIgnore pathsIgnoreExtended;

    public ContextDeserializer() {
        super(ContextIgnore.class);
    }

    @Override
    public ContextIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.createYaml();
        ContextIgnore contextIgnore = new ContextIgnore();
        JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (this.validationProcessor.validate(root)) {
            Iterator<Map.Entry<String, JsonNode>> it = root.fields();
            block14: while (it.hasNext()) {
                Map.Entry<String, JsonNode> globalScope = it.next();
                switch (globalScope.getKey()) {
                    case "version": {
                        contextIgnore.setVersion(globalScope.getValue().asText());
                        continue block14;
                    }
                    case "project": {
                        contextIgnore.setProject(globalScope.getValue().asText());
                        continue block14;
                    }
                    case "info": {
                        contextIgnore.setInfo(globalScope.getValue().asText());
                        continue block14;
                    }
                    case "paths": {
                        this.pathsIgnore = objectMapper.convertValue((Object)globalScope.getValue(), PathsIgnore.class);
                        this.extendPostProcess();
                        contextIgnore.setPaths(this.pathsIgnore);
                        continue block14;
                    }
                    case "extends": {
                        this.extend(globalScope);
                        continue block14;
                    }
                }
                throw new SpecificationSupportException(String.format("Specification does not support value \"%s\", please referenced the documentation for supported entries.", globalScope.getKey()));
            }
        }
        return contextIgnore;
    }

    private void extendPostProcess() {
        if (this.pathsIgnoreExtended != null) {
            HashSet<String> keys = new HashSet<String>(this.pathsIgnoreExtended.getPaths().keySet());
            HashSet<String> deletedKeys = new HashSet<String>();
            for (String key : keys) {
                if (this.pathsIgnore.getPaths().containsKey(key)) {
                    this.pathsIgnoreExtended.getPaths().remove(key);
                    deletedKeys.add(key);
                    continue;
                }
                this.pathsIgnore.getPaths().put(key, this.pathsIgnoreExtended.getPaths().get(key));
            }
            if (!deletedKeys.isEmpty()) {
                log.warn(String.format("You are overriding default values from the ignore files you extended. (%s)", deletedKeys));
            }
        }
    }

    private void extend(Map.Entry<String, JsonNode> globalScope) throws IOException {
        if (this.pathsIgnore != null) {
            throw new SpecificationSupportException("extends key must be above paths ignore declaration.");
        }
        try (InputStream inputStream = this.getClass().getResourceAsStream("/" + globalScope.getValue().asText().trim());){
            ContextIgnore contextIgnoreExtended = ObjectMapperFactory.createJson().convertValue(new Yaml().load(inputStream), ContextIgnore.class);
            this.pathsIgnoreExtended = contextIgnoreExtended.getPaths();
        }
    }
}

