/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.ObjectMapperFactory;
import com.github.elibracha.deserializers.AbstractDeserializer;
import com.github.elibracha.models.ignore.Content;
import com.github.elibracha.models.ignore.StatusIgnore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StatusDeserializer
extends AbstractDeserializer<StatusIgnore> {
    public StatusDeserializer() {
        super(StatusIgnore.class);
    }

    @Override
    public StatusIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode statuses = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        StatusIgnore statusIgnore = new StatusIgnore();
        HashMap<String, Content> st = new HashMap<String, Content>();
        Iterator<Map.Entry<String, JsonNode>> it = statuses.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> statusScope = it.next();
            statusIgnore = (StatusIgnore)this.preProcess(statusIgnore, statusScope.getValue());
            if (this.checkWildCards(statusScope.getKey())) {
                List<String> keys = this.extractWildCards(statusScope.getKey());
                for (String sup : keys) {
                    if (statusIgnore.isIgnoreAll()) {
                        this.setMethod(sup, statusScope, st, true);
                        continue;
                    }
                    this.setMethod(sup, statusScope, st, false);
                }
                continue;
            }
            if (statusIgnore.isIgnoreAll()) {
                this.setMethod(statusScope.getKey(), statusScope, st, true);
                continue;
            }
            this.setMethod(statusScope.getKey(), statusScope, st, false);
        }
        statusIgnore.setStatus(st);
        return statusIgnore;
    }

    private void setMethod(String key, Map.Entry<String, JsonNode> statusScope, Map<String, Content> st, boolean ignoreAll) {
        Content content = new Content();
        content.setIgnoreAll(ignoreAll);
        Iterator<Map.Entry<String, JsonNode>> contentIt = statusScope.getValue().fields();
        while (contentIt.hasNext()) {
            Map.Entry<String, JsonNode> contentScope = contentIt.next();
            switch (contentScope.getKey()) {
                case "new": {
                    content.setNewContent(contentScope.getValue().booleanValue());
                }
                case "content": {
                    Content contentIgnore = ObjectMapperFactory.createYaml().convertValue((Object)contentScope.getValue(), Content.class);
                    content.setContentSchemas(contentIgnore.getContentSchemas());
                    content.setIgnoreAll(contentIgnore.isIgnoreAll());
                }
            }
        }
        st.put(key, content);
    }
}

