/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model.schema;

import com.github.elibracha.model.Changed;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.model.DiffResult;
import java.util.Objects;
import java.util.Optional;

public class ChangedWriteOnly
implements Changed {
    private final DiffContext context;
    private final boolean oldValue;
    private final boolean newValue;

    public ChangedWriteOnly(Boolean oldValue, Boolean newValue, DiffContext context) {
        this.context = context;
        this.oldValue = Optional.ofNullable(oldValue).orElse(false);
        this.newValue = Optional.ofNullable(newValue).orElse(false);
    }

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.oldValue, this.newValue)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.context.isRequest()) {
            return DiffResult.COMPATIBLE;
        }
        if (this.context.isResponse()) {
            if (Boolean.TRUE.equals(this.newValue)) {
                return DiffResult.INCOMPATIBLE;
            }
            return this.context.isRequired() != false ? DiffResult.INCOMPATIBLE : DiffResult.COMPATIBLE;
        }
        return DiffResult.UNKNOWN;
    }
}

