/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.output;

import com.github.elibracha.model.Changed;
import com.github.elibracha.model.ChangedApiResponse;
import com.github.elibracha.model.ChangedContent;
import com.github.elibracha.model.ChangedMediaType;
import com.github.elibracha.model.ChangedMetadata;
import com.github.elibracha.model.ChangedOpenApi;
import com.github.elibracha.model.ChangedOperation;
import com.github.elibracha.model.ChangedParameter;
import com.github.elibracha.model.ChangedParameters;
import com.github.elibracha.model.ChangedResponse;
import com.github.elibracha.model.ChangedSchema;
import com.github.elibracha.model.ChangedSecurityRequirement;
import com.github.elibracha.model.ChangedSecurityRequirements;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.model.DiffResult;
import com.github.elibracha.model.Endpoint;
import com.github.elibracha.output.Render;
import com.github.elibracha.utils.RefPointer;
import com.github.elibracha.utils.RefType;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HtmlRender
implements Render {
    private String title;
    private String linkCss;
    protected static RefPointer<Schema> refPointer = new RefPointer(RefType.SCHEMAS);
    protected ChangedOpenApi diff;

    public HtmlRender() {
        this("Api Change Log", "http://deepoove.com/swagger-diff/stylesheets/demo.css");
    }

    public HtmlRender(String title, String linkCss) {
        this.title = title;
        this.linkCss = linkCss;
    }

    @Override
    public String render(ChangedOpenApi diff) {
        this.diff = diff;
        List<Endpoint> newEndpoints = diff.getNewEndpoints();
        ContainerTag ol_newEndpoint = this.ol_newEndpoint(newEndpoints);
        List<Endpoint> missingEndpoints = diff.getMissingEndpoints();
        ContainerTag ol_missingEndpoint = this.ol_missingEndpoint(missingEndpoints);
        List<Endpoint> deprecatedEndpoints = diff.getDeprecatedEndpoints();
        ContainerTag ol_deprecatedEndpoint = this.ol_deprecatedEndpoint(deprecatedEndpoints);
        List<ChangedOperation> changedOperations = diff.getChangedOperations();
        ContainerTag ol_changed = this.ol_changed(changedOperations);
        return this.renderHtml(ol_newEndpoint, ol_missingEndpoint, ol_deprecatedEndpoint, ol_changed);
    }

    public String renderHtml(ContainerTag ol_new, ContainerTag ol_miss, ContainerTag ol_deprec, ContainerTag ol_changed) {
        ContainerTag html = ((ContainerTag)TagCreator.html().attr("lang", "en")).with(TagCreator.head().with(new DomContent[]{TagCreator.meta().withCharset("utf-8"), TagCreator.title(this.title), ((EmptyTag)TagCreator.link().withRel("stylesheet")).withHref(this.linkCss)}), TagCreator.body().with(TagCreator.header().with((DomContent)TagCreator.h1(this.title)), ((ContainerTag)TagCreator.div().withClass("article")).with(TagCreator.div().with(TagCreator.h2("What's New"), TagCreator.hr(), ol_new), TagCreator.div().with(TagCreator.h2("What's Deleted"), TagCreator.hr(), ol_miss), TagCreator.div().with(TagCreator.h2("What's Deprecated"), TagCreator.hr(), ol_deprec), TagCreator.div().with(TagCreator.h2("What's Changed"), TagCreator.hr(), ol_changed))));
        return TagCreator.document().render() + html.render();
    }

    private ContainerTag ol_newEndpoint(List<Endpoint> endpoints) {
        if (null == endpoints) {
            return TagCreator.ol();
        }
        ContainerTag ol = TagCreator.ol();
        for (Endpoint endpoint : endpoints) {
            ol.with((DomContent)this.li_newEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
        }
        return ol;
    }

    private ContainerTag li_newEndpoint(String method, String path, String desc) {
        return TagCreator.li().with((DomContent)TagCreator.span(method).withClass(method)).withText(path + " ").with((DomContent)TagCreator.span(desc));
    }

    private ContainerTag ol_missingEndpoint(List<Endpoint> endpoints) {
        if (null == endpoints) {
            return TagCreator.ol();
        }
        ContainerTag ol = TagCreator.ol();
        for (Endpoint endpoint : endpoints) {
            ol.with((DomContent)this.li_missingEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
        }
        return ol;
    }

    private ContainerTag li_missingEndpoint(String method, String path, String desc) {
        return TagCreator.li().with(new DomContent[]{TagCreator.span(method).withClass(method), TagCreator.del().withText(path)}).with((DomContent)TagCreator.span(" " + desc));
    }

    private ContainerTag ol_deprecatedEndpoint(List<Endpoint> endpoints) {
        if (null == endpoints) {
            return TagCreator.ol();
        }
        ContainerTag ol = TagCreator.ol();
        for (Endpoint endpoint : endpoints) {
            ol.with((DomContent)this.li_deprecatedEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
        }
        return ol;
    }

    private ContainerTag li_deprecatedEndpoint(String method, String path, String desc) {
        return TagCreator.li().with(new DomContent[]{TagCreator.span(method).withClass(method), TagCreator.del().withText(path)}).with((DomContent)TagCreator.span(" " + desc));
    }

    private ContainerTag ol_changed(List<ChangedOperation> changedOperations) {
        if (null == changedOperations) {
            return TagCreator.ol();
        }
        ContainerTag ol = TagCreator.ol();
        for (ChangedOperation changedOperation : changedOperations) {
            String pathUrl = changedOperation.getPathUrl();
            String method = changedOperation.getHttpMethod().toString();
            String desc = Optional.ofNullable(changedOperation.getSummary()).map(ChangedMetadata::getRight).orElse("");
            ContainerTag ul_detail = (ContainerTag)TagCreator.ul().withClass("detail");
            if (Changed.result(changedOperation.getParameters()).isDifferent()) {
                ul_detail.with((DomContent)TagCreator.li().with((DomContent)TagCreator.h3("Parameters")).with((DomContent)this.ul_param(changedOperation.getParameters())));
            }
            if (changedOperation.resultRequestBody().isDifferent()) {
                ul_detail.with((DomContent)TagCreator.li().with((DomContent)TagCreator.h3("Request")).with((DomContent)this.ul_request(changedOperation.getRequestBody().getContent())));
            }
            if (changedOperation.resultApiResponses().isDifferent()) {
                ul_detail.with((DomContent)TagCreator.li().with((DomContent)TagCreator.h3("Response")).with((DomContent)this.ul_response(changedOperation.getApiResponses())));
            }
            if (changedOperation.getSecurityRequirements() != null && changedOperation.getSecurityRequirements().isDifferent()) {
                ul_detail.with((DomContent)TagCreator.li().with((DomContent)TagCreator.h3("Security")).with((DomContent)this.ul_security(changedOperation.getSecurityRequirements())));
            }
            ol.with((DomContent)TagCreator.li().with((DomContent)TagCreator.span(method).withClass(method)).withText(pathUrl + " ").with((DomContent)TagCreator.span(desc)).with((DomContent)ul_detail));
        }
        return ol;
    }

    private ContainerTag ul_security(ChangedSecurityRequirements apiSecurityReq) {
        List<ChangedSecurityRequirement> changedSecurity = apiSecurityReq.getChanged();
        ContainerTag ul = (ContainerTag)TagCreator.ul().withClass("change security");
        if (changedSecurity != null) {
            changedSecurity.forEach(e -> ul.with((DomContent)this.li_addSecurity((ChangedSecurityRequirement)e)));
        }
        return ul;
    }

    private ContainerTag ul_response(ChangedApiResponse changedApiResponse) {
        Map<String, ApiResponse> addResponses = changedApiResponse.getIncreased();
        Map<String, ApiResponse> delResponses = changedApiResponse.getMissing();
        Map<String, ChangedResponse> changedResponses = changedApiResponse.getChanged();
        ContainerTag ul = (ContainerTag)TagCreator.ul().withClass("change response");
        for (String propName : addResponses.keySet()) {
            ul.with((DomContent)this.li_addResponse(propName, addResponses.get(propName)));
        }
        for (String propName : delResponses.keySet()) {
            ul.with((DomContent)this.li_missingResponse(propName, delResponses.get(propName)));
        }
        for (String propName : changedResponses.keySet()) {
            ul.with((DomContent)this.li_changedResponse(propName, changedResponses.get(propName)));
        }
        return ul;
    }

    private ContainerTag li_addSecurity(ChangedSecurityRequirement requirement) {
        return TagCreator.li(new DomContent[]{TagCreator.div(String.format("changed security : New -> [%s]", requirement.getNewSecurityRequirement())).withClass("comment")}).with((DomContent)TagCreator.div("changed security : Old -> " + requirement.getOldSecurityRequirement()).withClass("missing"));
    }

    private ContainerTag li_addResponse(String name, ApiResponse response) {
        return TagCreator.li().withText(String.format("New response : [%s]", name)).with((DomContent)TagCreator.span(null == response.getDescription() ? "" : "//" + response.getDescription()).withClass("comment"));
    }

    private ContainerTag li_missingResponse(String name, ApiResponse response) {
        return TagCreator.li().withText(String.format("Deleted response : [%s]", name)).with((DomContent)TagCreator.span(null == response.getDescription() ? "" : "//" + response.getDescription()).withClass("comment"));
    }

    private ContainerTag li_changedResponse(String name, ChangedResponse response) {
        return TagCreator.li().withText(String.format("Changed response : [%s]", name)).with((DomContent)TagCreator.span(null == response.getNewApiResponse() || null == response.getNewApiResponse().getDescription() ? "" : "//" + response.getNewApiResponse().getDescription()).withClass("comment")).with((DomContent)this.ul_request(response.getContent()));
    }

    private ContainerTag ul_request(ChangedContent changedContent) {
        ContainerTag ul = (ContainerTag)TagCreator.ul().withClass("change request-body");
        if (changedContent != null) {
            for (String propName : changedContent.getIncreased().keySet()) {
                ul.with((DomContent)this.li_addRequest(propName, changedContent.getIncreased().get(propName)));
            }
            for (String propName : changedContent.getMissing().keySet()) {
                ul.with((DomContent)this.li_missingRequest(propName, changedContent.getMissing().get(propName)));
            }
            for (String propName : changedContent.getChanged().keySet()) {
                ul.with((DomContent)this.li_changedRequest(propName, changedContent.getChanged().get(propName)));
            }
        }
        return ul;
    }

    private ContainerTag li_addRequest(String name, MediaType request) {
        return TagCreator.li().withText(String.format("New body: '%s'", name));
    }

    private ContainerTag li_missingRequest(String name, MediaType request) {
        return TagCreator.li().withText(String.format("Deleted body: '%s'", name));
    }

    private ContainerTag li_changedRequest(String name, ChangedMediaType request) {
        ContainerTag li = TagCreator.li().with((DomContent)this.div_changedSchema(request.getSchema())).withText(String.format("Changed body: '%s'", name));
        if (request.isIncompatible()) {
            this.incompatibilities(li, request.getSchema());
        }
        return li;
    }

    private ContainerTag div_changedSchema(ChangedSchema schema) {
        ContainerTag div = TagCreator.div();
        div.with((DomContent)TagCreator.h3("Schema" + (schema.isIncompatible() ? " incompatible" : "")));
        return div;
    }

    private void incompatibilities(ContainerTag output, ChangedSchema schema) {
        this.incompatibilities(output, "", schema);
    }

    private void incompatibilities(ContainerTag output, String propName, ChangedSchema schema) {
        if (schema.getItems() != null) {
            this.items(output, propName, schema.getItems());
        }
        if (schema.isCoreChanged() == DiffResult.INCOMPATIBLE && schema.isChangedType()) {
            String type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
            this.property(output, propName, "Changed property type", type);
        }
        String prefix = propName.isEmpty() ? "" : propName + ".";
        this.properties(output, prefix, "Missing property", schema.getMissingProperties(), schema.getContext());
        schema.getChangedProperties().forEach((name, property) -> this.incompatibilities(output, prefix + name, (ChangedSchema)property));
    }

    private void items(ContainerTag output, String propName, ChangedSchema schema) {
        this.incompatibilities(output, propName + "[n]", schema);
    }

    private void properties(ContainerTag output, String propPrefix, String title, Map<String, Schema> properties, DiffContext context) {
        if (properties != null) {
            properties.forEach((key, value) -> this.property(output, propPrefix + key, title, this.resolve((Schema)value)));
        }
    }

    protected void property(ContainerTag output, String name, String title, Schema schema) {
        this.property(output, name, title, this.type(schema));
    }

    protected void property(ContainerTag output, String name, String title, String type) {
        output.with((DomContent)TagCreator.p(String.format("%s: %s (%s)", title, name, type)).withClass("missing"));
    }

    protected Schema resolve(Schema schema) {
        return refPointer.resolveRef(this.diff.getNewSpecOpenApi().getComponents(), schema, schema.get$ref());
    }

    protected String type(Schema schema) {
        String result = "object";
        if (schema instanceof ArraySchema) {
            result = "array";
        } else if (schema.getType() != null) {
            result = schema.getType();
        }
        return result;
    }

    private ContainerTag ul_param(ChangedParameters changedParameters) {
        List<Parameter> addParameters = changedParameters.getIncreased();
        List<Parameter> delParameters = changedParameters.getMissing();
        List<ChangedParameter> changed = changedParameters.getChanged();
        ContainerTag ul = (ContainerTag)TagCreator.ul().withClass("change param");
        for (Parameter parameter : addParameters) {
            ul.with((DomContent)this.li_addParam(parameter));
        }
        for (ChangedParameter changedParameter : changed) {
            ul.with((DomContent)this.li_changedParam(changedParameter));
        }
        for (Parameter parameter : delParameters) {
            ul.with((DomContent)this.li_missingParam(parameter));
        }
        return ul;
    }

    private ContainerTag li_addParam(Parameter param) {
        return TagCreator.li().withText("Add " + param.getName() + " in " + param.getIn()).with((DomContent)TagCreator.span(null == param.getDescription() ? "" : "//" + param.getDescription()).withClass("comment"));
    }

    private ContainerTag li_missingParam(Parameter param) {
        return ((ContainerTag)TagCreator.li().withClass("missing")).with((DomContent)TagCreator.span("Delete")).with((DomContent)TagCreator.del(param.getName())).with((DomContent)TagCreator.span("in ").withText(param.getIn())).with((DomContent)TagCreator.span(null == param.getDescription() ? "" : "//" + param.getDescription()).withClass("comment"));
    }

    private ContainerTag li_deprecatedParam(ChangedParameter param) {
        return ((ContainerTag)TagCreator.li().withClass("missing")).with((DomContent)TagCreator.span("Deprecated")).with((DomContent)TagCreator.del(param.getName())).with((DomContent)TagCreator.span("in ").withText(param.getIn())).with((DomContent)TagCreator.span(null == param.getNewParameter().getDescription() ? "" : "//" + param.getNewParameter().getDescription()).withClass("comment"));
    }

    private ContainerTag li_changedParam(ChangedParameter changeParam) {
        if (changeParam.isDeprecated()) {
            return this.li_deprecatedParam(changeParam);
        }
        boolean changeRequired = changeParam.isChangeRequired();
        boolean changeDescription = changeParam.getDescription().isDifferent();
        Parameter rightParam = changeParam.getNewParameter();
        Parameter leftParam = changeParam.getNewParameter();
        ContainerTag li = TagCreator.li().withText(changeParam.getName() + " in " + changeParam.getIn());
        if (changeRequired) {
            li.withText(" change into " + (rightParam.getRequired() != false ? "required" : "not required"));
        }
        if (changeDescription) {
            li.withText(" Notes ").with((DomContent)TagCreator.del(leftParam.getDescription()).withClass("comment")).withText(" change into ").with((DomContent)TagCreator.span(rightParam.getDescription()).withClass("comment"));
        }
        return li;
    }
}

