/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.processors;

import com.github.elibracha.model.ChangedOperation;
import com.github.elibracha.models.ignore.HttpMethodIgnore;
import com.github.elibracha.models.ignore.OperationIgnore;
import com.github.elibracha.processors.ParameterProcessor;
import com.github.elibracha.processors.RequestProcessor;
import com.github.elibracha.processors.ResponseProcessor;
import com.github.elibracha.processors.SecurityProcessor;

public class HttpMethodProcessor {
    private final RequestProcessor requestProcessor = new RequestProcessor();
    private final SecurityProcessor securityProcessor = new SecurityProcessor();
    private final ParameterProcessor parameterProcessor = new ParameterProcessor();
    private final ResponseProcessor responseProcessor = new ResponseProcessor();

    public boolean apply(HttpMethodIgnore httpMethodIgnore, ChangedOperation changedOperation) {
        String httpMethod = changedOperation.getHttpMethod().name().toLowerCase();
        OperationIgnore operationIgnore = httpMethodIgnore.checkIfIgnoreExist(httpMethod);
        if (operationIgnore != null && operationIgnore.isIgnoreAll() || httpMethodIgnore.isIgnoreAll()) {
            return true;
        }
        if (operationIgnore != null) {
            boolean responseResult;
            boolean parameterResult;
            boolean securityResult;
            boolean requestResult;
            if (operationIgnore.getRequest() != null && changedOperation.getRequestBody() != null && (requestResult = this.requestProcessor.apply(operationIgnore.getRequest(), changedOperation.getRequestBody()))) {
                changedOperation.setRequestBody(null);
            }
            if (operationIgnore.getSecurity() != null && changedOperation.getSecurityRequirements() != null && (securityResult = this.securityProcessor.apply(operationIgnore.getSecurity(), changedOperation.getSecurityRequirements()))) {
                changedOperation.setSecurityRequirements(null);
            }
            if (operationIgnore.getParameters() != null && changedOperation.getParameters() != null && (parameterResult = this.parameterProcessor.apply(operationIgnore.getParameters(), changedOperation.getParameters()))) {
                changedOperation.setParameters(null);
            }
            if (operationIgnore.getResponse() != null && changedOperation.getApiResponses() != null && (responseResult = this.responseProcessor.apply(operationIgnore.getResponse(), changedOperation.getApiResponses()))) {
                changedOperation.setApiResponses(null);
            }
        }
        return changedOperation.getRequestBody() == null && changedOperation.getSecurityRequirements() == null && changedOperation.getParameters() == null && changedOperation.getApiResponses() == null;
    }
}

