/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.processors;

import com.github.elibracha.model.Changed;
import com.github.elibracha.model.ChangedMediaType;
import com.github.elibracha.model.ChangedRequestBody;
import com.github.elibracha.models.ignore.Content;
import com.github.elibracha.models.ignore.ContentSchema;
import com.github.elibracha.models.ignore.RequestIgnore;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.ArrayList;
import java.util.Map;

public class RequestProcessor {
    public boolean apply(RequestIgnore requestIgnore, ChangedRequestBody requestBody) {
        ArrayList<String> changeToRemove = new ArrayList<String>();
        ArrayList<String> missingAndIncreaseToRemove = new ArrayList<String>();
        if (requestIgnore.isIgnoreAll()) {
            return true;
        }
        if (requestBody.getContent() != null) {
            boolean result;
            for (Map.Entry<String, ChangedMediaType> entry : requestBody.getContent().getChanged().entrySet()) {
                result = this.processMediaTypeChanged(entry.getKey(), entry.getValue(), requestIgnore.getContent());
                if (!result) continue;
                changeToRemove.add(entry.getKey());
            }
            for (Map.Entry<String, Object> entry : requestBody.getContent().getMissing().entrySet()) {
                result = this.processMediaTypeMissingOrIncrease(entry.getKey(), (MediaType)entry.getValue(), requestIgnore.getContent());
                if (!result) continue;
                missingAndIncreaseToRemove.add(entry.getKey());
            }
            for (Map.Entry<String, Object> entry : requestBody.getContent().getIncreased().entrySet()) {
                result = this.processMediaTypeMissingOrIncrease(entry.getKey(), (MediaType)entry.getValue(), requestIgnore.getContent());
                if (!result) continue;
                missingAndIncreaseToRemove.add(entry.getKey());
            }
            requestBody.getContent().getChanged().keySet().removeAll(changeToRemove);
            requestBody.getContent().getIncreased().keySet().removeAll(missingAndIncreaseToRemove);
            requestBody.getContent().getMissing().keySet().removeAll(missingAndIncreaseToRemove);
            return !(requestBody.getContent().getChanged() != null && requestBody.getContent().getChanged().size() != 0 || requestBody.getContent().getMissing() != null && requestBody.getContent().getMissing().size() != 0 || requestBody.getContent().getIncreased() != null && requestBody.getContent().getIncreased().size() != 0);
        }
        return true;
    }

    private boolean processMediaTypeMissingOrIncrease(String key, MediaType value, Content content) {
        if (content != null) {
            for (Map.Entry<String, ContentSchema> ignoreEntry : content.getContentSchemas().entrySet()) {
                if (!ignoreEntry.getKey().matches(key) || !ignoreEntry.getValue().isIgnoreAll() && !ignoreEntry.getValue().getSchema().getProperties().contains(value.getSchema().getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean processMediaTypeChanged(String key, ChangedMediaType value, Content content) {
        for (Map.Entry<String, ContentSchema> entry : content.getContentSchemas().entrySet()) {
            if (!entry.getKey().matches(key) || value.getChangedElements().size() <= 0) continue;
            for (Changed changedMediaType : value.getChangedElements()) {
                if (entry.getValue().isIgnoreAll()) {
                    return true;
                }
                if (!changedMediaType.isDifferent()) continue;
                System.out.println();
            }
        }
        return false;
    }
}

