/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.models.validations.ValidationResult;
import com.github.elibracha.models.validations.enums.HttpMethodSupport;
import com.github.elibracha.models.validations.enums.ValidationStatus;
import com.github.elibracha.validators.OperationValidator;
import com.github.elibracha.validators.Validator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HttpMethodValidator
implements Validator {
    private final OperationValidator operationValidator = new OperationValidator();
    private final ValidationResult result = new ValidationResult();
    private JsonNode httpMethod;

    @Override
    public boolean validate() {
        List supported = Arrays.stream(HttpMethodSupport.values()).map(HttpMethodSupport::getValue).collect(Collectors.toList());
        Iterator<Map.Entry<String, JsonNode>> it = this.httpMethod.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> httpMethodScope = it.next();
            if (!supported.contains(httpMethodScope.getKey()) && !httpMethodScope.getKey().equals("$")) {
                this.result.setMessage(String.format("the method \"%s\" not a valid entry in http method", httpMethodScope.getKey()));
                this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
                return false;
            }
            this.operationValidator.setOperations(httpMethodScope.getValue());
            if (this.operationValidator.validate()) continue;
            this.result.setMessage(this.operationValidator.getResult().getMessage());
            this.result.setValidationStatus(this.operationValidator.getResult().getValidationStatus());
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setHttpMethod(tree);
    }

    public OperationValidator getOperationValidator() {
        return this.operationValidator;
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public JsonNode getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(JsonNode httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMethodValidator)) {
            return false;
        }
        HttpMethodValidator other = (HttpMethodValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperationValidator this$operationValidator = this.getOperationValidator();
        OperationValidator other$operationValidator = other.getOperationValidator();
        if (this$operationValidator == null ? other$operationValidator != null : !((Object)this$operationValidator).equals(other$operationValidator)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        JsonNode this$httpMethod = this.getHttpMethod();
        JsonNode other$httpMethod = other.getHttpMethod();
        return !(this$httpMethod == null ? other$httpMethod != null : !((Object)this$httpMethod).equals(other$httpMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpMethodValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperationValidator $operationValidator = this.getOperationValidator();
        result = result * 59 + ($operationValidator == null ? 43 : ((Object)$operationValidator).hashCode());
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        JsonNode $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        return result;
    }

    public String toString() {
        return "HttpMethodValidator(operationValidator=" + this.getOperationValidator() + ", result=" + this.getResult() + ", httpMethod=" + this.getHttpMethod() + ")";
    }
}

