/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.models.validations.ValidationResult;
import com.github.elibracha.models.validations.enums.OperationSupport;
import com.github.elibracha.models.validations.enums.ValidationStatus;
import com.github.elibracha.validators.ParamsValidator;
import com.github.elibracha.validators.RequestValidator;
import com.github.elibracha.validators.ResponseValidator;
import com.github.elibracha.validators.SecurityValidator;
import com.github.elibracha.validators.Validator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperationValidator
implements Validator {
    private final ValidationResult result = new ValidationResult();
    private final ResponseValidator responseValidator = new ResponseValidator();
    private final RequestValidator requestValidator = new RequestValidator();
    private final ParamsValidator paramsValidator = new ParamsValidator();
    private final SecurityValidator securityValidator = new SecurityValidator();
    private JsonNode operations;

    @Override
    public boolean validate() {
        List supported = Arrays.stream(OperationSupport.values()).map(OperationSupport::getValue).collect(Collectors.toList());
        Iterator<Map.Entry<String, JsonNode>> it = this.operations.fields();
        while (it.hasNext()) {
            boolean r;
            Map.Entry<String, JsonNode> operationScope = it.next();
            if (!supported.contains(operationScope.getKey()) && !operationScope.getKey().equals("$")) {
                this.result.setMessage(String.format("the value \"%s\" is not a valid entry in operation", operationScope.getKey()));
                this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
                return false;
            }
            if (operationScope.getKey().equals("request")) {
                this.requestValidator.setRequest(operationScope.getValue());
                r = this.requestValidator.validate();
                if (!r) {
                    this.result.setMessage(this.requestValidator.getResult().getMessage());
                    this.result.setValidationStatus(this.requestValidator.getResult().getValidationStatus());
                    return false;
                }
            }
            if (operationScope.getKey().equals("response")) {
                this.responseValidator.setResponse(operationScope.getValue());
                r = this.responseValidator.validate();
                if (!r) {
                    this.result.setMessage(this.responseValidator.getResult().getMessage());
                    this.result.setValidationStatus(this.responseValidator.getResult().getValidationStatus());
                    return false;
                }
            }
            if (operationScope.getKey().equals("parameters")) {
                this.paramsValidator.setParams(operationScope.getValue());
                r = this.paramsValidator.validate();
                if (!r) {
                    this.result.setMessage(this.paramsValidator.getResult().getMessage());
                    this.result.setValidationStatus(this.paramsValidator.getResult().getValidationStatus());
                    return false;
                }
            }
            if (!operationScope.getKey().equals("security")) continue;
            this.securityValidator.setSecurity(operationScope.getValue());
            r = this.securityValidator.validate();
            if (r) continue;
            this.result.setMessage(this.securityValidator.getResult().getMessage());
            this.result.setValidationStatus(this.securityValidator.getResult().getValidationStatus());
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setOperations(tree);
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public ResponseValidator getResponseValidator() {
        return this.responseValidator;
    }

    public RequestValidator getRequestValidator() {
        return this.requestValidator;
    }

    public ParamsValidator getParamsValidator() {
        return this.paramsValidator;
    }

    public SecurityValidator getSecurityValidator() {
        return this.securityValidator;
    }

    public JsonNode getOperations() {
        return this.operations;
    }

    public void setOperations(JsonNode operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationValidator)) {
            return false;
        }
        OperationValidator other = (OperationValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        ResponseValidator this$responseValidator = this.getResponseValidator();
        ResponseValidator other$responseValidator = other.getResponseValidator();
        if (this$responseValidator == null ? other$responseValidator != null : !((Object)this$responseValidator).equals(other$responseValidator)) {
            return false;
        }
        RequestValidator this$requestValidator = this.getRequestValidator();
        RequestValidator other$requestValidator = other.getRequestValidator();
        if (this$requestValidator == null ? other$requestValidator != null : !((Object)this$requestValidator).equals(other$requestValidator)) {
            return false;
        }
        ParamsValidator this$paramsValidator = this.getParamsValidator();
        ParamsValidator other$paramsValidator = other.getParamsValidator();
        if (this$paramsValidator == null ? other$paramsValidator != null : !((Object)this$paramsValidator).equals(other$paramsValidator)) {
            return false;
        }
        SecurityValidator this$securityValidator = this.getSecurityValidator();
        SecurityValidator other$securityValidator = other.getSecurityValidator();
        if (this$securityValidator == null ? other$securityValidator != null : !((Object)this$securityValidator).equals(other$securityValidator)) {
            return false;
        }
        JsonNode this$operations = this.getOperations();
        JsonNode other$operations = other.getOperations();
        return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        ResponseValidator $responseValidator = this.getResponseValidator();
        result = result * 59 + ($responseValidator == null ? 43 : ((Object)$responseValidator).hashCode());
        RequestValidator $requestValidator = this.getRequestValidator();
        result = result * 59 + ($requestValidator == null ? 43 : ((Object)$requestValidator).hashCode());
        ParamsValidator $paramsValidator = this.getParamsValidator();
        result = result * 59 + ($paramsValidator == null ? 43 : ((Object)$paramsValidator).hashCode());
        SecurityValidator $securityValidator = this.getSecurityValidator();
        result = result * 59 + ($securityValidator == null ? 43 : ((Object)$securityValidator).hashCode());
        JsonNode $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : $operations.hashCode());
        return result;
    }

    public String toString() {
        return "OperationValidator(result=" + this.getResult() + ", responseValidator=" + this.getResponseValidator() + ", requestValidator=" + this.getRequestValidator() + ", paramsValidator=" + this.getParamsValidator() + ", securityValidator=" + this.getSecurityValidator() + ", operations=" + this.getOperations() + ")";
    }
}

